# $Id: List.pm 33319 2010-12-10 15:55:27Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Users/List.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Users::List::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok', map {
		my ($uid, $name, $admin) = @$_;
		[user => [uid => $uid], [name => $name], [admin => $admin ? 'true' : 'false']]
	} @{$req->users}));
}

package UvT::Squarepeg::Ajax::Users::List::Request;

use Xyzzy::Request -self;

field users => sub {
	my $self = shift;

	die $self->errorpage('permission_denied')
		unless $self->isadmin;

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT uid, name, admin FROM mailnames ORDER BY uid');
	$q->execute;
	my $res = $q->fetchall_arrayref;
	$q->finish;

	$db->commit;

	return $res;
};

package UvT::Squarepeg::Ajax::Users::List;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Users::List::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Users::List::Document(req => $req);
	return $doc->response;
}
