# $Id: Get.pm 33556 2011-01-18 10:40:08Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Get.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Get::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok',
		[uid => $req->uid],
		[name => $req->name],
		[admin => $req->admin ? 'true' : 'false']
	));
}

package UvT::Squarepeg::Ajax::User::Get::Request;

use UvT::Squarepeg::Ajax::User::Request -self;

field uid => sub {
	my $self = shift;

	my $uid = super;

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT name, admin FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	$db->commit;

	die $self->errorpage('uid_does_not_exist', uid => $uid)
		unless @$res;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_user($uid);

	my ($name, $admin) = @{$res->[0]};
	$self->name($name);
	$self->admin($admin);

	return $uid;
};

field name => sub { shift->uid; return };

field admin => sub { shift->uid; return };

package UvT::Squarepeg::Ajax::User::Get;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Get::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::User::Get::Document(req => $req);
	return $doc->response;
}
