# $Id: Nonce.pm 33275 2010-12-08 14:30:06Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Nonce.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Nonce::Document;

use Xyzzy::Document -self;

sub build {
	my $nonce = $self->cfg->crypto->create_token('n'.$self->req->session);
	$self->setDocumentElement($self->construct('ok', [nonce => $nonce]));
}

package UvT::Squarepeg::Ajax::Nonce;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $doc = new UvT::Squarepeg::Ajax::Nonce::Document(req => shift);
	return $doc->response;
}
