# $Id: Error.pm 33275 2010-12-08 14:30:06Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Error.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Error;

use Xyzzy::Document -self;

field type;
field args;

sub build {
	my $type = $self->type;
	utf8::upgrade($type);
	my $root = $self->createElement("error_$type");
	my $args = $self->args;
	while(my ($key, $val) = each(%$args)) {
		utf8::upgrade($key);
		utf8::upgrade($val);
		$root->appendTextChild($key, $val);
	}
	$self->setDocumentElement($root);
}
