# $Id: Delete.pm 33555 2011-01-18 10:18:21Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Box/Delete.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Box::Delete::Request;

use UvT::Squarepeg::Ajax::Box::Request -self;

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $box = $self->box;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_box($box);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('user_not_box', uid => $box)
		if @$res;

	$q = $db->prepare_cached('DELETE FROM mailboxes WHERE box = ?');
	$q->execute($box);
	$q->finish;

	$db->commit;

	system($self->cfg->syncboxes);

	return [[box => $box]];
};

package UvT::Squarepeg::Ajax::Box::Delete;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Box::Delete::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

