// $Id: users.js 33623 2011-01-24 14:34:56Z wsl $
// $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/www/users.js $

window.onload = function() {
	var colinfo = new Array(
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_icon';
				var img = document.createElement('img');
				img.setAttribute('src', '/squarepeg/static/user-icon');
				img.setAttribute('alt', 'User');
				td.appendChild(img);
				return td;
			}
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_short';
				var a = document.createElement('a');
				a.setAttribute('href', '/squarepeg/user/' + vs.uid);
				UvT.setTableText(a, vs.uid);
				td.appendChild(a);
				return td;
			},
			function(td, vs) { vs.uid = UvT.getText(td); }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_long';
				UvT.setTableText(td, vs.name);
				return td;
			},
			function(td, vs) { vs.name = UvT.getText(td); },
			function(vs) {
				var inp = document.createElement('input');
				inp.setAttribute('type', 'text');
				inp.setAttribute('value', vs.name);
				var td = document.createElement('td');
				td.className = 'edit_long';
				td.appendChild(inp);
				return td;
			},
			function(td, vs) { vs.name = td.childNodes[0].value; }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_admin';
				UvT.setTableText(td, vs.admin == 'true' ? 'admin' : '');
				return td;
			},
			function(td, vs) { vs.admin = UvT.getText(td) == 'admin' ? 'true' : 'false'; },
			function(vs) {
				var inp = UvT.construct('input', {type: 'checkbox'});
				inp.checked = vs.admin == 'true';
				var td = UvT.construct('td', ['label', inp, 'admin?']);
				td.className = 'edit_admin';
				return td;
			},
			function(td, vs) { vs.admin = td.childNodes[0].checked ? 'true' : 'false'; }
		)
	);

	UvT.getNonce();
	setInterval(UvT.getNonce, 60000);

	var us = document.getElementById('userlist');
	var et = new UvT.EditableTable(us, '/squarepeg/ajax/rest/users', colinfo, 'uid');

	var knopje = document.getElementById('addnewusers');
	var veldje = document.getElementById('newusers');

	function addedUsers(o) {
		var root = o.responseXML.documentElement;
		var raw = '';
		if(root.tagName != 'ok')
			return;
		var rs = root.childNodes;
		for(var i = 0; i < rs.length; i++) {
			var r = rs[i];
			if(r.tagName == undefined)
				continue;
			var info = UvT.deconstruct(r);
			if(r.tagName == 'ok') {
				et.addrow(info);
			} else {
				if(info.uid != undefined) {
					if(info.uid == info.name)
						raw += info.uid + "\n";
					else
						raw += info.uid + " " + info.name + "\n";
				}
				et.showfail(r.tagName, info);
			}
		}
		veldje.value = raw;
	}

	function addUsers(raw) {
		var q = 'nonce=' + encodeURIComponent(window.nonce)
			+ '&raw=' + encodeURIComponent(raw);
		YAHOO.util.Connect.asyncRequest('POST', '/squarepeg/ajax/rest/users', {
			success: addedUsers,
			failure: function() {},
			timeout: 5000
		}, q);
		et.clearfail();
	}

	knopje.onclick = function() { addUsers(veldje.value); };
};
