// $Id: common.js 33652 2011-01-25 12:15:20Z wsl $
// $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/www/common.js $

function log(msg) {
	if(window.console) {
		console.debug(msg);
	} else {
		setTimeout(function() {
			throw new Error(msg);
		}, 0);
	}
}

window.UvT = {
	format_error: function(code, info) {
		var n = 'format_' + code;
		var f = window.UvT[n];
		if(f != undefined)
			return f(info);
		else
			return "Something went wrong";
	},

	format_error_bad_nonce: function(info) {
		return "Session expired, please reload this page";
	},

	format_error_box_does_not_exist: function(info) {
		var box = info.box;
		if(box == defined)
			return "The mailbox '" + box + "' does not exist";
		else
			return "Mailbox does not exist";
	},

	format_error_box_exists: function(info) {
		var uid = info.uid;
		var box = info.box;
		var existing = info.existing;
		return uid == undefined
			? box == undefined
				? "Mailbox already present"
				: existing == undefined || existing == box
					? "The mailbox '" + box + "' is already present"
					: "The mailbox '" + box + "' is already present (" + existing + ")"
			: box == undefined
				? "Mailbox already present for user " + uid
				: existing == undefined || existing == box
					? "The mailbox '" + box + "' is already present for user " + uid
					: "The mailbox '" + box + "' is already present (" + existing + ") for user " + uid;
	},

	format_error_box_not_user: function(info) {
		var box = info.box;
		return box == undefined
			? "Requested user ID is a mailbox"
			: "'" + box + "' is a mailbox";
	},

	format_error_link_does_not_exist: function(info) {
		var uid = info.uid;
		var box = info.box;
		return uid == undefined
			? box == undefined
				? "The requested mailbox is not available to this user"
				: "The mailbox '" + box + "' is not available to this user"
			: box == undefined
				? "The requested mailbox is not available to " + uid
				: "The mailbox '" + box + "' is not available to " + uid;
	},

	format_error_malformed_parameter: function(info) {
		var param = info.param;
		return param == undefined
			? "The server was unable to interpret the request"
			: param == 'name' ? "Please simplify the full name"
			: param == 'uid' ? "Please simplify the name"
			: param == 'box' ? "Please simplify the name"
			: "The server was unable to interpret the request"
	},

	format_error_missing_parameter: function(info) {
		var param = info.param;
		return param == undefined
			? "There was a problem communicating with the server"
			: "Please supply a " + param;
	},

	format_error_permission_denied: function(info) {
		return "You have not yet been marked as an administrator for this resource";
	},

	format_error_uid_does_not_exist: function(info) {
		var uid = info.uid;
		var name = info.name;
		return uid == undefined
			? "This user ID does not exist"
			: "The user ID " + uid + " does not exist";
	},

	format_error_uid_exists_ldap: function(info) {
		var uid = info.uid;
		var ldap = info.ldap;
		return uid == undefined
			? "The requested mailbox name is already in use (in LDAP)"
			: ldap == undefined
				? "The mailbox name '" + uid + "' is already in use (in LDAP, for " + ldap + ")"
				: "The mailbox name '" + uid + "' is already in use (in LDAP)";
	},

	format_error_user_not_box: function(info) {
		var uid = info.uid;
		var name = info.name;
		return uid == undefined
			? "The requested mailbox name is already in use"
			: name == undefined
				? "The mailbox name '" + uid + "' is already in use (in LDAP, for " + name + ")"
				: "The mailbox name '" + uid + "' is already in use (in LDAP)";
	},

	format_error_box_invalid: function(info) {
		var box = info.box;
		var name = info.name;
		return box == undefined
			? "Please simplify the mailbox name"
			: "Please simplify the mailbox name '" + box + "'";
	},

	format_error_link_exists: function(info) {
		var box = info.box;
		var name = info.name;
		var quota = info.quota;
		return box == undefined
			? "This mailbox is already available"
			: "The mailbox '" + box + "' is already available";
	},

	format_error_uid_exists: function(info) {
		var uid = info.uid;
		var existing = info.existing;
		return uid == undefined
			? "The requested mailbox name is already in use"
			: existing == undefined
				? "The mailbox name '" + uid + "' is already in use (for " + existing + ")"
				: "The mailbox name '" + uid + "' is already in use";
	},

	format_error_uid_invalid: function(info) {
		var uid = info.uid;
		var name = info.name;
		return uid == undefined
			? "This user name does not exist"
			: "The user name '" + uid + "' does not exist";
	},

	construct: function(n) {
		var e = document.createElement(n);
		for(var i = 1; i < arguments.length; i++) {
			var a = arguments[i];
			var t = typeof(a);
			if(t == 'object') {
				t = Object.prototype.toString.call(a);
				if(t === '[object Array]') {
					e.appendChild(UvT.construct.apply(null, a));
				} else {
					try {
						e.appendChild(a);
					} catch(exc) {
						for(var k in a)
							e.setAttribute(k, a[k]);
					}
				}
			} else {
				e.appendChild(document.createTextNode(a));
			}
		}
		return e;
	},

	deconstruct: function(e) {
		var info = {};
		var fs = e.childNodes;
		for(var j = 0; j < fs.length; j++) {
			var f = fs[j];
			var n = f.tagName;
			if(n == undefined)
				continue;
			info[n] = f.textContent == undefined
				? f.text
				: f.textContent;
		}
		return info;
	},

	getText: function(e) {
		if(e.textContent == undefined)
			return e.innerText;
		else
			return e.textContent;
	},

	getAjaxText: function(e) {
		if(e.textContent == undefined)
			return e.text;
		else
			return e.textContent;
	},

	setText: function(e, t) {
		if(e.textContent == undefined)
			return e.innerText = t;
		else
			return e.textContent = t;
	},

	setTableText: function(e, t) {
		return UvT.setText(e, t == '' ? '\u00A0' : t);
	},

	append: function(h) {
		for(var i = 1; i < arguments.length; i++) {
			var a = arguments[i];
			for(var x in a)
				h[x] = a[x];
		}
	},

	EditableColumn: function(val2ro, ro2val, val2rw, rw2val) {
		this.ro2val = ro2val;
		this.val2ro = val2ro;
		this.rw2val = rw2val;
		this.val2rw = val2rw;
	},

	EditableTable: function(table, url, colinfo, idcol) {
		var current_tr;
		var timeout;
		var editing;
		var id2row = {};

		function restorefunc() {
			var cs = current_tr.cells;
			var vals = current_tr.squarepeg;
			for(var i = 0; i < colinfo.length; i++) {
				var a = colinfo[i];
				if(a.val2ro != undefined)
					current_tr.replaceChild(a.val2ro(vals), cs[i]);
			}

			var td = document.createElement('td');
			td.className = 'edit_controls';
			UvT.setTableText(td, '');
			current_tr.replaceChild(td, cs[colinfo.length]);

			current_tr = undefined;
			editing = false;
		}

		function cancelfunc() {
			restorefunc();
		}

		function failfunc(msg) {
			if(!current_tr)
				return;
			var cs = current_tr.childNodes[colinfo.length].childNodes;
			var err = cs[cs.length - 1];
			UvT.setText(err, msg);
		}

		function showfail(code, info) {
			var msg = UvT.format_error(code, info);
			var ul = document.getElementById('errors');
			var li = UvT.construct('li', msg);
			ul.appendChild(li);
		};

		this.showfail = showfail;

		function clearfail() {
			var ul = document.getElementById('errors');
			var cs = ul.childNodes;
			for(var i = cs.length; i > 0; i--)
				ul.removeChild(cs[i - 1]);
		};

		this.clearfail = clearfail;

		function successfunc(o) {
			// meuk uit o peuren, in current_tr frutten en restorefunc
			// aanroepen (of foutmelding tonen)
			var root = o.responseXML.documentElement;
			var info = UvT.deconstruct(root);
			if(root.tagName == 'ok') {
				UvT.append(current_tr.squarepeg, info);
				restorefunc();
			} else {
				failfunc(UvT.format_error(root.tagName, info));
			}
		}

		function savefunc() {
			var cs = current_tr.cells;

			var vs = {};
			UvT.append(vs, current_tr.squarepeg, {nonce: window.nonce});

			for(var i = 0; i < colinfo.length; i++) {
				var a = colinfo[i];
				if(a.rw2val != undefined)
					a.rw2val(cs[i], vs);
			}

			var id = vs[idcol];
			if(id == undefined)
				throw new Error("Internal error");
			delete vs[idcol];

			var args = new Array();
			for(var n in vs)
				args.push(n + '=' + encodeURIComponent(vs[n]));
			var q = args.join('&');

			var resurl = url + '/' + encodeURIComponent(id);

			YAHOO.util.Connect.initHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
			YAHOO.util.Connect.asyncRequest('PUT', resurl, {
				success: successfunc,
				failure: function() { failfunc('Error contacting server'); },
				timeout: 5000
			}, q);

			failfunc('');
		}

		function exitfunc() {
			timeout = undefined;
			if(editing)
				return;
			if(current_tr) {
				var old = current_tr.cells[colinfo.length];
				var td = document.createElement('td');
				td.className = 'edit_controls';
				UvT.setTableText(td, '');
				current_tr.replaceChild(td, old);
				current_tr = undefined;
			}
		}

		function editfunc() {
			editing = true;

			var values = current_tr.squarepeg;

			var cs = current_tr.cells;
			for(var i = 0; i < colinfo.length; i++) {
				var a = colinfo[i];
				if(a.val2rw != undefined)
					current_tr.replaceChild(a.val2rw(values), cs[i]);
			}

			var save_button = document.createElement('button');
			save_button.onclick = savefunc;
			UvT.setText(save_button, 'Save');
			var cancel_button = document.createElement('button');
			cancel_button.onclick = cancelfunc;
			UvT.setText(cancel_button, 'Cancel');
			var err = document.createElement('span');
			err.className = 'edit_errors';

			var td = document.createElement('td');
			td.className = 'edit_controls';
			td.appendChild(save_button);
			td.appendChild(cancel_button);
			td.appendChild(err);
			current_tr.replaceChild(td, cs[colinfo.length]);
		}

		function removedfunc(o) {
			var root = o.responseXML.documentElement;
			if(root.tagName == 'ok') {
				var info = UvT.deconstruct(root);
				var tr = id2row[info[idcol]];
				delete id2row[info[idcol]];
				fadeout_and_remove(tr);
			} else {
				failfunc('computer says no');
			}
		}

		function removefunc() {
			var id = current_tr.squarepeg[idcol];
			if(confirm('Really remove ' + idcol + ' "' + id + '"?')) {
				var resurl = url + '/' + encodeURIComponent(id);
				var q = 'nonce=' + encodeURIComponent(window.nonce);

				YAHOO.util.Connect.initHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
				YAHOO.util.Connect.asyncRequest('DELETE', resurl, {
					success: removedfunc,
					failure: function() { failfunc('Error contacting server'); },
					timeout: 5000
				}, q);

				clearfail();
			}
			exitfunc();
		}

		function buttonfunc() {
			var tr = this;
			if(timeout) {
				clearTimeout(timeout);
				timeout = undefined;
			}
			if(editing)
				return;
			if(current_tr != tr) {
				exitfunc();
				var cs = tr.cells;
				var td = document.createElement('td');
				td.className = 'edit_controls';
				var b = document.createElement('button');
				b.onclick = editfunc;
				UvT.setText(b, 'Edit');
				td.appendChild(b);
				var b = document.createElement('button');
				b.onclick = removefunc;
				UvT.setText(b, 'Remove');
				td.appendChild(b);
				tr.replaceChild(td, cs[colinfo.length]);
				current_tr = tr;
			}
		}

		function addrow(fields) {
			var tr = document.createElement('tr');
			id2row[fields[idcol]] = tr;
			for(var i = 0; i < colinfo.length; i++) {
				var a = colinfo[i];
				tr.appendChild(a.val2ro(fields));
			}

			tr.onmouseover = buttonfunc;

			var td = document.createElement('td');
			UvT.setTableText(td, '');
			td.className = 'edit_controls';
			tr.appendChild(td);
			if(table.firstChild == undefined)
				table.appendChild(tr);
			else
				table.insertBefore(tr, table.firstChild);
			tr.squarepeg = fields;
			return tr;
		}

		table.onmouseout = function() {
			if(timeout)
				clearTimeout(timeout);
			timeout = undefined;
			if(editing)
				return;
			timeout = setTimeout(exitfunc, 500);
		};

		function initfunc(o) {
			var root = o.responseXML.documentElement;
			if(root.tagName != 'ok') {
				var info = UvT.deconstruct(root);
				clearfail();
				return showfail(root.tagName, info);
			}

			var cs = root.childNodes;
			for(var i = cs.length; i > 0; i--) {
				var e = cs[i - 1];
				if(e.tagName == undefined)
					continue;

				var info = UvT.deconstruct(e);

				addrow(info);
			}
			return null;
		}

		YAHOO.util.Connect.asyncRequest('GET', url, {
			success: initfunc,
			failure: function() { failfunc('Error contacting server'); },
			timeout: 5000
		});

		function time() {
			var d = new Date();
			return d.getTime();
		}

		function fadein(tr, s) {
			var period = 200;
			var i = 0;
			if(s == undefined)
				s = time();
			else
				i = time() - s;
			if(i > period)
				i = period;
			var o = i / period;
			tr.style.opacity = o * o;
			if(i < period)
				setTimeout(function(){fadein(tr, s);}, 1);
		}

		this.addrow = function(fields) {
			var tr = addrow(fields);
			fadein(tr);
		};

		function fadeout_and_remove(tr, s) {
			var period = 200;
			var i = 0;
			if(s == undefined)
				s = time();
			else
				i = time() - s;
			if(i > period)
				i = period;
			var o = 1 - i / period;
			tr.style.opacity = o * o;
			if(i < period)
				setTimeout(function(){fadeout_and_remove(tr, s);}, 1);
			else
				tr.parentNode.removeChild(tr);
		}

	},

	getNonce: function() {
		YAHOO.util.Connect.asyncRequest('GET', '/squarepeg/ajax/nonce', {
			success: function(o) {
				var root = o.responseXML.documentElement;
				if(root.tagName != 'ok')
					return;
				var info = UvT.deconstruct(root);
				window.nonce = '' + info.nonce;
			},
			failure: function() {},
			timeout: 5000
		});
	},

	bytes_to_human: function(b) {
		var units = ['B', 'KiB', 'MiB', 'GiB', 'TiB'];
		var i = 0;
		b = parseInt(b);
		if(b == 0)
			return '0';
		while(b > 999) {
			b /= 1024;
			i++;
		}
		return parseInt(b) + ' ' + units[i];
	},

	bytes_to_GiB: function(b) {
		return parseInt((parseInt(b) + 536870912) / 1073741824);
	},

	GiB_to_bytes: function(g) {
		return g * 1073741824;
	}
};
