# $Id: User.pm 33619 2011-01-24 13:13:09Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/User.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::User::Document;

use UvT::Squarepeg::Document -self;

sub build {
	$self->addTemplates('user');

	my ($js) = $self->getFragment('javascript', 'user');
	$self->getElementById('head')->appendChild($js);

	my $req = $self->req;

	if(my $span = $self->getElementById('uid')) {
		$span->appendText($req->uid);
	}

	if(my $span = $self->getElementById('username')) {
		$span->appendText($req->name);
	}
}

package UvT::Squarepeg::User::Request;

use Xyzzy::Request -self;

field uid => sub {
	return shift->path_components->[0]
		// confess("Path component missing");
};

field name => sub {
    my $self = shift;

    my $uid = $self->uid;

    my $db = $self->db;

    my $q = $db->prepare_cached('SELECT name FROM mailnames WHERE uid = ?');
    $q->execute($uid);
    my $res = $q->fetchall_arrayref;
    $q->finish;

	$db->commit;

    die $self->errorpage('uid_does_not_exist', uid => $uid)
        unless @$res;

    die $self->errorpage('permission_denied')
        unless $self->isadmin_for_user($uid);

    my ($name) = @{$res->[0]};

    return $name;
};

package UvT::Squarepeg::User;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::User::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::User::Document(req => $req);
	return $doc->response;
}
