# $Id: Root.pm 33559 2011-01-18 15:38:55Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Root.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Error;

use UvT::Squarepeg::Document -self;

field type;
field args;

sub build {
	my $type = $self->type;

    $self->addTemplates("error", "error/$type");

	while(my ($key, $val) = each(%{$self->args})) {
		my $elem = $self->getElementById($key);
		next unless $elem;
		if($val) {
			$elem->appendText($val);
		} else {
			$elem->parentNode->removeChild($elem);
		}
	}
}

package UvT::Squarepeg::Root::Request;

use Xyzzy::Request -self;

field aselectcookie => undef;
field sessioncookie => undef;

const session => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my $crypto = $cfg->crypto;

	my $salt;
	eval {
		my $session = $self->cookie('squarepeg_session');
		(undef, $salt) = $crypto->check_token('s', $session);

		my $nonce = $self->param('nonce');
		$crypto->check_token('n'.$salt, $nonce, $cfg->nonce_expiry);
		$self->{nonce} = $nonce;
	};
#	warn $@ if $@;

	unless(defined $salt) {
		(undef, $salt, my $session) = $crypto->create_token('s', '');
		$self->sessioncookie($session);
	}

	return $salt;
};

const nonce => sub { # return 1; # HACK
	# figuring out and checking the nonce is a side-effect of session():
	shift->session;
	return;
};

sub errorpage {
    my ($type, %args) = @_;
	my $doc = new UvT::Squarepeg::Error(req => $self, type => $type, args => \%args);
	return $doc->response;
}

package UvT::Squarepeg::Root;

use UvT::Squarepeg::Handler -self;

sub handle {
	local $SIG{__DIE__} = sub { my $err = shift; die $err if ref $err || $err =~ /\n/; confess $err };
	my $req = new UvT::Squarepeg::Root::Request(cfg => $self, ctx => shift);
	$req->session;
	my $res = eval { super($req) };
	return $res if defined $res;
	die $@ if ref $@;
	warn $@ if $@;
	die $req->errorpage('internal');
}
