# $Id: Portal.pm 33619 2011-01-24 13:13:09Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Portal.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Portal::Document;

use UvT::Squarepeg::Document -self;

sub build {
	$self->addTemplates('portal');

	my $req = $self->req;

	if(my $a = $self->getElementById('service-page-link')) {
		$a->setAttribute('href', 'user/' . $req->login);
	}
}

sub response {
	my $req = $self->req;
	my $res = super;
	if(!$req->isadmin) {
		$res->status(302);
		$res->setheader(Location => $req->script_url . '/user/' . $req->login);
	}
	return $res;
}

package UvT::Squarepeg::Portal;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $doc = new UvT::Squarepeg::Portal::Document(req => shift);
	return $doc->response;
}
