# $Id: Method.pm 32665 2010-10-05 12:11:38Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Method.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Method::Request;

use Xyzzy::Request -self;

field method => sub { shift->request_method };

package UvT::Squarepeg::Method;

use Xyzzy::Handler -self;

use Xyzzy::Fail;

field methods => {};

sub handle {
	my $req = new UvT::Squarepeg::Method::Request(cfg => $self, ctx => shift);

	my $method = $req->method;

	my $handler = $self->methods->{$method};
	return $self->handler->handle($req, @_)
		unless $handler;

	return $handler->handle($req, @_);
}
