# $Id: Box.pm 33619 2011-01-24 13:13:09Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Box.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Box::Document;

use UvT::Squarepeg::Document -self;

sub build {
	$self->addTemplates('box');

	my ($js) = $self->getFragment('javascript', 'box');
	$self->getElementById('head')->appendChild($js);

	my $req = $self->req;

	if(my $span = $self->getElementById('mbox')) {
		$span->appendText($req->box);
	}

	if(my $span = $self->getElementById('boxname')) {
		$span->appendText($req->name);
	}
}

package UvT::Squarepeg::Box::Request;

use Xyzzy::Request -self;

field box => sub {
	return shift->path_components->[0]
		// confess("Path component missing");
};

field name => sub {
    my $self = shift;

    my $box = $self->box;

    my $db = $self->db;

    my $q = $db->prepare_cached('SELECT name FROM mailboxes WHERE box = ?');
    $q->execute($box);
    my $res = $q->fetchall_arrayref;
    $q->finish;

	$db->commit;

    die $self->errorpage('box_does_not_exist', box => $box)
        unless @$res;

    die $self->errorpage('permission_denied')
        unless $self->isadmin_for_box($box);

    my ($name) = @{$res->[0]};

    return $name;
};


package UvT::Squarepeg::Box;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Box::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Box::Document(req => $req);
	return $doc->response;
}
