# $Id: Aselect.pm 33562 2011-01-18 16:46:20Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Aselect.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Aselect::Config;

use Xyzzy -self;

field aselect_id => sub { die "no AselectID configured\n" };
*set_aselectid = *aselect_id;

package UvT::Squarepeg::Aselect::Document;

use UvT::Squarepeg::Document -self;

field url;
field msg => sub {};

sub build {
	my $msg = $self->msg;
	#$self->addTemplates($msg) if $msg;
}

sub response {
	my $res = super;
	$res->status(302);
	$res->setheader(Location => $self->url);
	return $res;
}

package UvT::Squarepeg::Aselect::Request;

use Aselect::Client;

use Xyzzy::Request -self;

param aselect_credentials;
param rid => sub { die shift->errorpage('aselect_rid_missing') unless defined };

field login => sub { # return 'wsl'; # HACK
	my $self = shift;
	my $cfg = $self->cfg;

	if(my $ticket = $self->cookie('squarepeg_aselect')) {
		my ($uid, $org) = eval { aselect_verify_ticket($ticket) };
		return lc($uid) unless $@;
		warn "aselect_verify_ticket: $@";
	}

	my $url = $self->self_url;

	if(my $cred = $self->aselect_credentials) {
		$url =~ s/([?&])rid=[^&]*(&)?/$2?$1:''/e;
		$url =~ s/([?&])aselect_credentials=[^&]*(&)?/$2?$1:''/e;
		$url =~ s/([?&])a-select-server=[^&]*(&)?/$2?$1:''/e;
		my $rid = $self->rid;
		my $ticket = eval { aselect_verify_credentials($rid, $cred) };
		if($@) {
			warn $@;
			die $self->errorpage('aselect_verify_credentials');
		} else {
			$self->aselectcookie($ticket);
			my $doc = new UvT::Squarepeg::Aselect::Document(req => $self, url => $url, msg => 'aselect_complete');
			die $doc->response;
		};
	}

	my $sso = aselect_authenticate($cfg->aselect_id, $url);
	my $doc = new UvT::Squarepeg::Aselect::Document(req => $self, url => $sso, msg => 'aselect_start');
	die $doc->response;
};

field isadmin => sub {
	my $self = shift;
	my $uid = $self->login;
	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT EXISTS(SELECT NULL FROM mailnames WHERE uid = ? AND admin)');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res->[0][0];
};

sub isadmin_for_user {
	my ($uid) = @_;
	my $user = $self->login;
	return lc($user) eq $uid || $self->isadmin;
}

sub isadmin_for_box {
	return 1 if $self->isadmin;
	my $uid = $self->login;
	my $box = shift;
	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT EXISTS(SELECT NULL FROM mailnames JOIN maillinks USING (mailuser) JOIN mailboxes USING (mailbox) WHERE uid = ? AND mailboxes.name = ? AND maillinks.admin)');
	$q->execute($uid, $box);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res->[0][0];
}

package UvT::Squarepeg::Aselect;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Aselect::Request(cfg => $self, ctx => shift);
	$req->login;
	return super($req);
}
