# $Id: Create.pm 33649 2011-01-25 10:19:30Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Users/Create.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Users::Create::Request;

use UvT::Squarepeg::Canonical;

use Xyzzy::Request -self;

param raw => sub {
	die shift->errorpage('missing_parameter', param => 'raw') unless $_;
};

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my @users =
		grep { @$_ }
		map { s/\s+/ /g; [split(' ', $_, 2)] }
		split(/\n/, $self->raw);

	my @results;

	my $db = $self->db;
	foreach my $user (@users) {
		my ($uid, $name) = @$user;
		$uid = canonical_identifier($uid);
		$name = canonical_name($name);

		unless(defined $uid) {
			push @results, ['error_uid_invalid', [uid => $uid], [name => $name // $uid]];
			next;
		}

		my $q = $db->prepare_cached('SELECT name FROM mailnames WHERE uid = ?');
		$q->execute($uid);
		my $res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			push @results, ['error_uid_exists', [uid => $uid], [name => $name // $uid], [existing => $existing]];
			next;
		}

		$q = $db->prepare_cached('SELECT name FROM mailboxes WHERE box = ?');
		$q->execute($uid);
		$res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			push @results, ['error_box_exists', [uid => $uid], [box => $uid], [name => $name // $uid], [existing => $existing]];
			next;
		}

		my $cn = $self->cfg->ldap->cn($uid);
		unless($cn) {
			push @results, ['error_uid_does_not_exist', [uid => $uid], [name => $name // $uid]];
			next;
		}

		$name //= $cn;
		my $uniq = $name;
		for(my $i = 2;; $i++) {
			$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE lower(name) = lower(?)');
			$q->execute($uniq);
			$res = $q->fetchall_arrayref;
			$q->finish;
			last unless @$res;
			$uniq = "$name #$i";
		}
		$name = $uniq;

		$q = $db->prepare_cached('INSERT INTO mailboxes (box, name) VALUES (?, ?)');
		$q->execute($uid, $name);
		$q->finish;

		$q = $db->prepare_cached('INSERT INTO mailusers (mailuser) VALUES ((SELECT mailbox FROM mailboxes WHERE box = ?))');
		$q->execute($uid);
		$q->finish;

		push @results, ['ok', [uid => $uid], [name => $name]];
	}
	$db->commit;

	system($self->cfg->syncboxes);

	return \@results;
};

package UvT::Squarepeg::Ajax::Users::Create;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Users::Create::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

