# $Id: Create.pm 33648 2011-01-25 10:05:40Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Boxes/Create.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Boxes::Create::Request;

use UvT::Squarepeg::Canonical;

use Xyzzy::Request -self;

param raw => sub {
	die shift->errorpage('missing_parameter', param => 'raw') unless $_;
};

field results => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	die $self->errorpage('permission_denied')
		unless $self->isadmin;

	my @boxes =
		grep { @$_ }
		map { s/\s+/ /g; [split(' ', $_, 2)] }
		split(/\n/, $self->raw);

	my @results;

	my $db = $self->db;
	foreach my $mailbox (@boxes) {
		my ($origbox, $name) = @$mailbox;
		my $box = canonical_identifier($origbox);
		$name = canonical_name($name);

		unless(defined $box) {
			push @results, ['error_box_invalid', [box => $origbox], [name => $name // $origbox]];
			next;
		}

		my $q = $db->prepare_cached('SELECT name FROM mailboxes WHERE box = ?');
		$q->execute($box);
		my $res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			push @results, ['error_box_exists', [box => $box], [name => $name // $box], [existing => $existing]];
			next;
		}

		$q = $db->prepare_cached('SELECT name FROM mailnames WHERE uid = ?');
		$q->execute($name);
		$res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			push @results, ['error_uid_exists', [uid => $box], [name => $name // $box], [existing => $existing]];
			next;
		}

		my $cn = $self->cfg->ldap->cn($box);
		if($cn) {
			push @results, ['error_uid_exists_ldap', [uid => $box], [name => $name // $box], [ldap => $cn]];
			next;
		}

		$name //= canonical_name($box);
		my $uniq = $name;
		for(my $i = 2;; $i++) {
			$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE lower(name) = lower(?)');
			$q->execute($uniq);
			$res = $q->fetchall_arrayref;
			$q->finish;
			last unless @$res;
			$uniq = "$name #$i";
		}
		$name = $uniq;

		$q = $db->prepare_cached('INSERT INTO mailboxes (box, name) VALUES (?, ?)');
		$q->execute($box, $name);
		$q->finish;

		$q = $db->prepare_cached('SELECT quota FROM mailboxes WHERE box = ?');
		$q->execute($box);
		$res = $q->fetchall_arrayref;
		$q->finish;

		confess("Can't find mailbox I just created?!")
			unless @$res;

		my $quota = $res->[0][0];
		
		push @results, ['ok', [box => $box], [name => $name], [quota => $quota]];
	}
	$db->commit;

	system($cfg->syncboxes);

	return \@results;
};

package UvT::Squarepeg::Ajax::Boxes::Create;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Boxes::Create::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

