# $Id: Ajax.pm 33275 2010-12-08 14:30:06Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok', @{$req->results}));
}

package UvT::Squarepeg::Ajax::Request;

use UvT::Squarepeg::Ajax::Error;

use Xyzzy::Request -self;

field aselectcookie => undef;

sub errorpage {
	my ($type, %args) = @_;
	my $doc = new UvT::Squarepeg::Ajax::Error(req => $self, type => $type, args => \%args);
	return $doc->response;
}

package UvT::Squarepeg::Ajax;

use UvT::Squarepeg::Ajax::Nonce;
use UvT::Squarepeg::Ajax::Users::Create;
use UvT::Squarepeg::Ajax::Users::List;
use UvT::Squarepeg::Ajax::User::Get;
use UvT::Squarepeg::Ajax::User::Modify;
use UvT::Squarepeg::Ajax::User::Delete;
use UvT::Squarepeg::Ajax::User::Box;
use UvT::Squarepeg::Ajax::User::Box::Get;
use UvT::Squarepeg::Ajax::User::Box::Modify;
use UvT::Squarepeg::Ajax::User::Box::Delete;
use UvT::Squarepeg::Ajax::User::Boxes::List;
use UvT::Squarepeg::Ajax::User::Boxes::Create;
use UvT::Squarepeg::Ajax::Boxes::Create;
use UvT::Squarepeg::Ajax::Boxes::List;
use UvT::Squarepeg::Ajax::Box::Get;
use UvT::Squarepeg::Ajax::Box::Modify;
use UvT::Squarepeg::Ajax::Box::Delete;
use UvT::Squarepeg::Ajax::Box::Users::List;
use UvT::Squarepeg::Ajax::Box::Users::Create;

use Xyzzy::Directory -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Request(cfg => $self, ctx => shift);
	my $res = eval { super($req) };
	return $res if defined $res;
	die $@ if ref $@;
	warn $@ if $@;
	die $req->errorpage('internal');
}
