# $Id: Squarepeg.pm 33619 2011-01-24 13:13:09Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Resources;

use UvT::Squarepeg::Crypto;
use UvT::Squarepeg::LDAP;
use UvT::Squarepeg::Quota;

use UvT::Squarepeg::Handler -self;

field crypto => sub { new UvT::Squarepeg::Crypto(cfg => shift->cfg) };
field ldap => sub { new UvT::Squarepeg::LDAP(cfg => shift->cfg) };
field quota => sub { new UvT::Squarepeg::Quota(cfg => shift->cfg) };

package UvT::Squarepeg;

use Xyzzy::Directory;
use UvT::Squarepeg::Root;
use UvT::Squarepeg::Aselect;
use UvT::Squarepeg::User;
use UvT::Squarepeg::Users;
use UvT::Squarepeg::Box;
use UvT::Squarepeg::Boxes;
use UvT::Squarepeg::Ajax;
use UvT::Squarepeg::Method;
use UvT::Squarepeg::ReST;
use UvT::Squarepeg::Portal;

use Xyzzy -self;

use UvT::Squarepeg::Config -mixin;
use UvT::Squarepeg::Crypto::Config -mixin;
use UvT::Squarepeg::Aselect::Config -mixin;
use UvT::Squarepeg::LDAP::Config -mixin;
use UvT::Squarepeg::Quota::Config -mixin;

sub handler {
	my $rsc = new UvT::Squarepeg::Resources(cfg => $self);

	my $link = new UvT::Squarepeg::Method(cfg => $rsc, methods => {
		GET => new UvT::Squarepeg::Ajax::User::Box::Get(cfg => $rsc),
		PUT => new UvT::Squarepeg::Ajax::User::Box::Modify(cfg => $rsc),
		DELETE => new UvT::Squarepeg::Ajax::User::Box::Delete(cfg => $rsc),
	});

	# generic:  /users
	# specific: /users/bob

	my $rest = new UvT::Squarepeg::ReST(cfg => $rsc,
		generic => {
			users => new UvT::Squarepeg::Method(cfg => $rsc, methods => { # /users
				GET => new UvT::Squarepeg::Ajax::Users::List(cfg => $rsc),
				POST => new UvT::Squarepeg::Ajax::Users::Create(cfg => $rsc),
			}),
			boxes => new UvT::Squarepeg::Method(cfg => $rsc, methods => { # /boxes
				GET => new UvT::Squarepeg::Ajax::Boxes::List(cfg => $rsc),
				POST => new UvT::Squarepeg::Ajax::Boxes::Create(cfg => $rsc),
			})
		},
		specific => {
			users => new UvT::Squarepeg::ReST(cfg => $rsc,
				handler => new UvT::Squarepeg::Method(cfg => $rsc, methods => { # /users/bob
					GET => new UvT::Squarepeg::Ajax::User::Get(cfg => $rsc),
					PUT => new UvT::Squarepeg::Ajax::User::Modify(cfg => $rsc),
					DELETE => new UvT::Squarepeg::Ajax::User::Delete(cfg => $rsc),
				}),
				generic => {
					boxes => new UvT::Squarepeg::Method(cfg => $rsc, methods => { # /users/bob/boxes
						GET => new UvT::Squarepeg::Ajax::User::Boxes::List(cfg => $rsc),
						POST => new UvT::Squarepeg::Ajax::User::Boxes::Create(cfg => $rsc),
					}),
				},
				specific => { boxes => $link } # /users/bob/boxes/sales
			),
			boxes => new UvT::Squarepeg::ReST(cfg => $rsc,
				handler => new UvT::Squarepeg::Method(cfg => $rsc, methods => { # /boxes/sales
					GET => new UvT::Squarepeg::Ajax::Box::Get(cfg => $rsc),
					PUT => new UvT::Squarepeg::Ajax::Box::Modify(cfg => $rsc),
					DELETE => new UvT::Squarepeg::Ajax::Box::Delete(cfg => $rsc),
				}),
				generic => {
					users => new UvT::Squarepeg::Method(cfg => $rsc, methods => { # /boxes/sales/users
						GET => new UvT::Squarepeg::Ajax::Box::Users::List(cfg => $rsc),
						POST => new UvT::Squarepeg::Ajax::Box::Users::Create(cfg => $rsc),
					}),
				},
				specific => { users => $link } # /boxes/sales/users/bob
			)
		},
	);

	my $ajax = new UvT::Squarepeg::Ajax(cfg => $rsc,
		subdirs => {
			nonce => new UvT::Squarepeg::Ajax::Nonce(cfg => $rsc),
			rest => $rest,
		}
	);

	my $handler = new Xyzzy::Directory(cfg => $rsc,
		subdirs => {
			user => new UvT::Squarepeg::User(cfg => $rsc),
			users => new UvT::Squarepeg::Users(cfg => $rsc),
			box => new UvT::Squarepeg::Box(cfg => $rsc),
			boxes => new UvT::Squarepeg::Boxes(cfg => $rsc),
			ajax => $ajax,
		},
		handler => new UvT::Squarepeg::Portal(cfg => $rsc)
	);

	$handler = new UvT::Squarepeg::Aselect(cfg => $rsc, handler => $handler);
	$handler = new Xyzzy::Database(cfg => $rsc, handler => $handler, db_name => 'dovecot', db_user => 'dovecot');
	$handler = new UvT::Squarepeg::Root(cfg => $rsc, handler => $handler);

	return $handler;
}
