// $Id: user.js 33639 2011-01-24 17:03:54Z wsl $
// $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/www/user.js $

window.onload = function() {
	var colinfo = new Array(
		new UvT.EditableColumn(
			function(v) {
				var td = document.createElement('td');
				td.className = 'edit_icon';
				var img = document.createElement('img');
				img.setAttribute('src', '/squarepeg/static/box-icon');
				img.setAttribute('alt', 'Mailbox');
				td.appendChild(img);
				return td;
			}
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_short';
				var a = document.createElement('a');
				a.setAttribute('href', '/squarepeg/box/' + vs.box);
				UvT.setTableText(a, vs.box);
				td.appendChild(a);
				return td;
			},
			function(td, vs) { vs.box = UvT.getText(td); }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_long';
				UvT.setTableText(td, vs.name);
				return td;
			},
			function(td, vs) { vs.name = UvT.getText(td); }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_quota';
				var u = UvT.bytes_to_human(vs.usage);
				var q = UvT.bytes_to_human(vs.quota);
				var p = parseInt(vs.usage * 100 / vs.quota);
				UvT.setTableText(td, u + ' / ' + q + ' (' + p + '%)');
				return td;
			},
			function(td, vs) { vs.quota = UvT.GiB_to_bytes(parseInt(UvT.getText(td))) }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_admin';
				UvT.setTableText(td, vs.admin == 'true' ? 'admin' : '');
				return td;
			},
			function(td, vs) { vs.admin = UvT.getText(td) == 'admin' ? 'true' : 'false'; },
			function(vs) {
				var inp = UvT.construct('input', {type: 'checkbox'});
				inp.checked = vs.admin == 'true';
				var td = UvT.construct('td', ['label', inp, 'admin?']);
				td.className = 'edit_admin';
				return td;
			},

			function(td, vs) { vs.admin = td.childNodes[0].checked ? 'true' : 'false'; }
		)
	);

	UvT.getNonce();
	setInterval(UvT.getNonce, 60000);

	var uid = top.location.pathname;
	uid = uid.substr(uid.lastIndexOf('/') + 1).toLowerCase();
	if(!uid.match(/^[a-z0-9_]+([.-][a-z0-9_]+)*$/))
		throw new Error("invalid username");

	var url = '/squarepeg/ajax/rest/users/'+uid+'/boxes';
	
	var us = document.getElementById('boxlist');
	var et = new UvT.EditableTable(us, url, colinfo, 'box');

	var knopje = document.getElementById('addnewboxes');
	var veldje = document.getElementById('newboxes');

	function addedUsers(o) {
		var root = o.responseXML.documentElement;
		var raw = '';
		if(root.tagName != 'ok')
			return;
		var rs = root.childNodes;
		for(var i = 0; i < rs.length; i++) {
			var r = rs[i];
			if(r.tagName == undefined)
				continue;
			var info = UvT.deconstruct(r);
			if(r.tagName == 'ok') {
				et.addrow(info);
			} else {
				if(info.box != undefined) {
					if(info.box == info.name)
						raw += info.box + "\n";
					else
						raw += info.box + " " + info.name + "\n";
				}
				et.showfail(r.tagName, info);
			}
		}
		veldje.value = raw;
	}

	function addUsers(raw) {
		var q = 'nonce=' + encodeURIComponent(window.nonce)
			+ '&raw=' + encodeURIComponent(raw);
		YAHOO.util.Connect.asyncRequest('POST', url, {
			success: addedUsers,
			failure: function() {},
			timeout: 5000
		}, q);
		et.clearfail();
	}

	if(knopje && veldje)
		knopje.onclick = function() { addUsers(veldje.value); };
};
