// $Id: boxes.js 33640 2011-01-24 17:06:34Z wsl $
// $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/www/boxes.js $

window.onload = function() {
	var colinfo = new Array(
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_icon';
				var img = document.createElement('img');
				img.setAttribute('src', '/squarepeg/static/box-icon');
				img.setAttribute('alt', 'Mailbox');
				td.appendChild(img);
				return td;
			}
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_short';
				var a = document.createElement('a');
				a.setAttribute('href', '/squarepeg/box/' + vs.box);
				UvT.setTableText(a, vs.box);
				td.appendChild(a);
				return td;
			},
			function(td, vs) { vs.box = UvT.getText(td); }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_long';
				UvT.setTableText(td, vs.name);
				return td;
			},
			function(td, vs) { vs.name = UvT.getText(td); },
			function(vs) {
				var inp = document.createElement('input');
				inp.setAttribute('type', 'text');
				inp.setAttribute('value', vs.name);
				var td = document.createElement('td');
				td.className = 'edit_long';
				td.appendChild(inp);
				return td;
			},
			function(td, vs) { vs.name = td.childNodes[0].value; }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_quota';
				var u = UvT.bytes_to_human(vs.usage);
				var q = UvT.bytes_to_human(vs.quota);
				var p = parseInt(vs.usage * 100 / vs.quota);
				UvT.setTableText(td, u + ' / ' + q + ' (' + p + '%)');
				return td;
			},
			function(td, vs) { vs.quota = UvT.GiB_to_bytes(parseInt(UvT.getText(td))) },
			function(vs) {
				var val = UvT.bytes_to_GiB(vs.quota);
				var inp = document.createElement('select');
				var cur;
				for(var i = 0; i < 4; i++) {
					var dis = 1 << i;
					var opt = UvT.construct('option', {value: dis}, dis + ' GiB');
					if(val >= dis || cur == undefined)
						cur = opt;
					inp.appendChild(opt);
				}
				cur.setAttribute('selected', 'selected');
				var td = document.createElement('td');
				td.className = 'edit_quota';
				td.appendChild(inp);
				return td;
			},
			function(td, vs) { vs.quota = UvT.GiB_to_bytes(td.childNodes[0].value); }
		)
	);

	UvT.getNonce();
	setInterval(UvT.getNonce, 60000);

	var us = document.getElementById('boxlist');
	var et = new UvT.EditableTable(us, '/squarepeg/ajax/rest/boxes', colinfo, 'box');

	var knopje = document.getElementById('addnewboxes');
	var veldje = document.getElementById('newboxes');

	function addedUsers(o) {
		var root = o.responseXML.documentElement;
		var raw = '';
		if(root.tagName != 'ok')
			return;
		var rs = root.childNodes;
		for(var i = 0; i < rs.length; i++) {
			var r = rs[i];
			if(r.tagName == undefined)
				continue;
			var info = UvT.deconstruct(r);
			if(r.tagName == 'ok') {
				et.addrow(info);
			} else {
				if(info.box != undefined) {
					if(info.box == info.name)
						raw += info.box + "\n";
					else
						raw += info.box + " " + info.name + "\n";
				}
				et.showfail(r.tagName, info);
			}
		}
		veldje.value = raw;
	}

	function addUsers(raw) {
		var q = 'nonce=' + encodeURIComponent(window.nonce)
			+ '&raw=' + encodeURIComponent(raw);
		YAHOO.util.Connect.asyncRequest('POST', '/squarepeg/ajax/rest/boxes', {
			success: addedUsers,
			failure: function() {},
			timeout: 5000
		}, q);
		et.clearfail();
	}

	knopje.onclick = function() { addUsers(veldje.value); };
};
