# $Id: Document.pm 32581 2010-09-24 13:59:41Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Document.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Document;

use Xyzzy::Document::Styled -self;

sub response {
	my $res = super;
	my $req = $self->req;

	if(my $session = $req->sessioncookie) {
		my $cookie = $self->bakecookie(squarepeg_session => $session);
		$res->setcookie($cookie);
	}

	if(my $aselect = $req->aselectcookie) {
		my $cookie = $self->bakecookie(squarepeg_aselect => $aselect);
		$res->setcookie($cookie);
	}

	return $res;
}
