# $Id: Delete.pm 33555 2011-01-18 10:18:21Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Delete.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Delete::Request;

use UvT::Squarepeg::Ajax::User::Request -self;

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $uid = $self->uid;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_user($uid);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	my $id = @$res && $res->[0][0];

	if($id) {
		$q = $db->prepare_cached('DELETE FROM mailboxes WHERE mailbox = ?');
		$q->execute($id);
		$q->finish;
	} else {
		$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE box = ?');
		$q->execute($uid);
		$res = $q->fetchall_arrayref;
		$q->finish;
		die $self->errorpage('box_not_user', box => $uid)
			if @$res;
	}

	$db->commit;

	system($self->cfg->syncboxes);

	return [[uid => $uid]];
};

package UvT::Squarepeg::Ajax::User::Delete;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Delete::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}
