# $Id: List.pm 33562 2011-01-18 16:46:20Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Boxes/List.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Boxes::List::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok', map {
		my ($box, $name, $quota, $usage, $admin) = @$_;
		[mbox => [box => $box], [name => $name], [quota => $quota], [usage => $usage // 0], [admin => $admin ? 'true' : 'false']]
	} @{$req->boxes}));
}

package UvT::Squarepeg::Ajax::User::Boxes::List::Request;

use UvT::Squarepeg::Ajax::User::Request -self;

field boxes => sub {
	my $self = shift;

	my $uid = $self->uid;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_user($uid);

	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT mailboxes.box, mailboxes.name, mailboxes.quota, maillinks.admin
		FROM mailnames JOIN maillinks USING (mailuser) JOIN mailboxes USING (mailbox)
		WHERE mailnames.uid = ? ORDER BY mailboxes.box');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	$db->commit;

	my $quota = $self->cfg->quota;

	my @res = map {
			my ($box, $name, $limit, $admin) = @$_;
			my $usage = $quota->get($box);
			[$box, $name, $limit, $usage, $admin]
		} @$res;

	return \@res;
};

package UvT::Squarepeg::Ajax::User::Boxes::List;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Boxes::List::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::User::Boxes::List::Document(req => $req);
	return $doc->response;
}
