# $Id: Create.pm 33635 2011-01-24 16:53:33Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Boxes/Create.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Boxes::Create::Request;

use UvT::Squarepeg::Canonical;

use UvT::Squarepeg::Ajax::User::Request -self;

param raw => sub {
	die shift->errorpage('missing_parameter', param => 'raw') unless $_;
};

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $uid = $self->uid;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_user($uid);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('uid_does_not_exist', uid => $uid)
		unless @$res;

	my ($mailuser) = @{$res->[0]};

	my @boxes =
		grep { @$_ }
		map { s/\s+/ /g; [split(' ', $_, 2)] }
		split(/\n/, $self->raw);

	my @results;

	foreach my $mbox (@boxes) {
		my ($origbox, $name) = @$mbox;
		my $box = canonical_identifier($origbox);
		$name = canonical_name($name);

		unless(defined $box) {
			push @results, ['error_box_invalid', [box => $origbox], [name => $name // $origbox]];
			next;
		}

		my $q = $db->prepare_cached('SELECT mailbox, name, quota FROM mailboxes WHERE box = ?');
		$q->execute($box);
		my $res = $q->fetchall_arrayref;
		$q->finish;

		unless(@$res) {
			push @results, ['error_box_does_not_exist', [box => $box], [name => $name // '']];
			next;
		}

		my ($mailbox, $quota);
		($mailbox, $name, $quota) = @{$res->[0]};

		$q = $db->prepare_cached('SELECT name FROM mailnames WHERE uid = ?');
		$q->execute($box);
		$res = $q->fetchall_arrayref;
		$q->finish;

		if(@$res) {
			push @results, ['error_user_not_box', [uid => $box], [name => $res->[0][0]]];
			next;
		}

		$q = $db->prepare_cached('SELECT 1 FROM maillinks WHERE mailuser = ? AND mailbox = ? FOR UPDATE');
		$q->execute($mailuser, $mailbox);
		$res = $q->fetchall_arrayref;
		$q->finish;

		if(@$res) {
			push @results, ['error_link_exists', [box => $box], [name => $name], [quota => $quota]];
		} else {
			$q = $db->prepare_cached('INSERT INTO maillinks (mailuser, mailbox) VALUES (?, ?)');
			$q->execute($mailuser, $mailbox);
			$q->finish;
			push @results, ['ok', [box => $box], [name => $name], [quota => $quota]];
		}
	}
	$db->commit;

	system($self->cfg->syncboxes);

	return \@results;
};

package UvT::Squarepeg::Ajax::User::Boxes::Create;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Boxes::Create::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

