# $Id: Get.pm 33556 2011-01-18 10:40:08Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Box/Get.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Box::Get::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok',
		[uid => $req->uid],
		[box => $req->box],
		[admin => $req->admin ? 'true' : 'false']
	));
}

package UvT::Squarepeg::Ajax::User::Box::Get::Request;

use UvT::Squarepeg::Ajax::User::Box::Request -self;

field admin => sub {
	my $self = shift;

	my $db = $self->db;

	my $uid = $self->uid;

	my $q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('uid_does_not_exist', uid => $uid)
		unless @$res;
	my ($mailuser) = @{$res->[0]};

	my $box = $self->box;

	$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE box = ?');
	$q->execute($box);
	$res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('box_does_not_exist', box => $box)
		unless @$res;
	my ($mailbox) = @{$res->[0]};

	$q = $db->prepare_cached('SELECT admin FROM maillinks WHERE mailuser = ? AND mailbox = ?');
	$q->execute($mailuser, $mailbox);
	$res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_user($uid) || $self->isadmin_for_box($box);

	die $self->errorpage('link_does_not_exist', uid => $uid, box => $box)
		unless @$res;

	$db->commit;

	my ($admin) = @{$res->[0]};

	return $admin;
};

package UvT::Squarepeg::Ajax::User::Box::Get;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Box::Get::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::User::Box::Get::Document(req => $req);
	return $doc->response;
}
