# $Id: Get.pm 33556 2011-01-18 10:40:08Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Box/Get.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Box::Get::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok',
		[box => $req->box],
		[name => $req->name],
		[quota => $req->quota],
		[usage => $req->usage]
	));
}

package UvT::Squarepeg::Ajax::Box::Get::Request;

use UvT::Squarepeg::Ajax::Box::Request -self;

field box => sub {
	my $self = shift;

	my $box = super;

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT name, quota FROM mailboxes WHERE box = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	$db->commit;

	die $self->errorpage('box_does_not_exist', box => $box)
		unless @$res;

	die $self->errorpage('permission_denied')
		unless $self->isadmin_for_box($box);

	my ($name, $quota) = @{$res->[0]};
	$self->name($name);
	$self->quota($quota);

	return $box;
};

field name => sub { shift->box; return };

field quota => sub { shift->box; return };

field usage => sub {
	my $self = shift;
	return $self->cfg->quota->get($self->box) // 0;
};

package UvT::Squarepeg::Ajax::Box::Get;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Box::Get::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Box::Get::Document(req => $req);
	return $doc->response;
}
