# $Id: SQL.pm 37765 2012-09-06 14:50:08Z anton $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/pwdmodifier/lib/UvT/PwdModifier/SQL.pm $
#
# Er wordt door deze app geschreven naar adb123, die wordt eens in het uur ofzo gelezen
# in het GLW en de waarden worden dan overgenomen naar
# GLW-INGRES tabel: adb113 en de Oracle tabel adb113r. (r is replica).
# (Is inhoudelelijk hetzelfde als adb313 in de mibase).
# Initiëel worden de passwords ook door DEA in adb113r geplaatst.
#
# IDM
# Vanuit FIM wordt usernamentabel adb413usernaam bijgewerkt en die gaat naar Mibase en Ingres.
# Dit is adb113(r) zonder passwords.
# describe adb413usernaam;


# Schrijven en lezen moet voortaan alleen in adb123

# describe adb113r@lnkdea.kub.nl;
# USERNAAM       NOT NULL VARCHAR2(8)
# ANR            NOT NULL CHAR(6)
# CAT            CHAR(1)
# PWSERV         VARCHAR2(30) initëel cleartext password
# PW_SHA         VARCHAR2(150)
# PW_GPG         VARCHAR2(1500)
# PW_RCRYPT      VARCHAR2(200)
# USNUITG        datum uitgifte datepasswchanged			 VARCHAR2(8)
# USNVERV        datum vervallen					 VARCHAR2(8)
# USNSTAT        status, (moet 'a' zijn om naar ldap gestuurd te worden)
#
# describe adb123@lnkdea.kub.nl;
# Name			   Null?    Type
# ANR			   NOT NULL CHAR(6)
# USERNAME		   NOT NULL CHAR(8)
# PW_SHA_BEFORE		   NOT NULL VARCHAR2(150)
# PW_RCRYPT_BEFORE	   NOT NULL VARCHAR2(200)
# PW_SHA_AFTER		   NOT NULL VARCHAR2(150)
# PW_RCRYPT_AFTER	   NOT NULL VARCHAR2(200)
# CHANGE_TIME		   NOT NULL DATE
# CHANGED_BY		   VARCHAR2(40)
# TO_INGRES		   DATE

# describe adb131@lnkdea;
# ANR			   NOT NULL CHAR(6)
# EXTMAIL		   VARCHAR2(80)
# TOGLW			   CHAR(1)
# TOGLW_DATE	   DATE
# EPOCH_TIME	   NUMBER(10)
#
#
# describe adb132@lnkdea;
# ANR			   NOT NULL CHAR(6)
# SEQ			   NOT NULL NUMBER
# VRAAG			   NOT NULL VARCHAR2(256)
# ANTWOORD		   NOT NULL VARCHAR2(256)
#

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::SQL;

use Spiffy -Base;

use DBI;
use Data::Dumper;

field 'db';
field 'dsn', -init => 'die "no dsn configured\n"';
field 'user', -init => 'die "no db user configured\n"';
field 'pass' => '';

our $dbi_options = {
	AutoCommit => 0,
    PrintError => 0,
    RaiseError => 1,
    ShowErrorStatement => 1,
};

sub new {
	$self = super;
	my $db = DBI->connect($self->dsn, $self->user, $self->pass, $dbi_options);

	#tijdelijke reparatie statements
	$self->{getDirtyRecords} = $db->prepare("SELECT  pw_rcrypt_before, epoch_time, anr, change_time FROM adb123\@lnkdea.kub.nl WHERE change_time > '14-dec-10' ORDER BY epoch_time");
	$self->{cleanRecord} = $db->prepare("UPDATE adb123\@lnkdea.kub.nl SET pw_rcrypt_before = ? WHERE anr=? AND epoch_time=?");



	$self->{getAccount} = $db->prepare("SELECT anr, usernaam FROM adb413usernaam\@lnkpg WHERE anr = ? AND usnstat in ('A','E')");
	$self->{getUsername} = $db->prepare("SELECT usernaam FROM adb413usernaam\@lnkpg WHERE anr = ? AND usnstat in ('A','E')");

	$self->{getAnr} = $db->prepare("SELECT anr FROM adb413usernaam\@lnkpg WHERE usernaam = lower(?) AND usnstat in ('A','E')");
	$self->{previousPasswords} = $db->prepare("SELECT pw_rcrypt_after FROM adb123\@lnkdea.kub.nl WHERE anr = ? ORDER BY change_time");
	$self->{previousSHAPasswords} = $db->prepare("SELECT pw_sha_after FROM adb123\@lnkdea.kub.nl WHERE anr = ? ORDER BY change_time");
	$self->{initialPassword} = $db->prepare("SELECT pwserv FROM adb113r\@lnkdea.kub.nl WHERE anr = ?");

	$self->{setPwd} = $db->prepare(
		'INSERT INTO adb123@lnkdea.kub.nl (anr, username, pw_sha_before, pw_rcrypt_before, pw_sha_after, pw_rcrypt_after,
		changed_by, epoch_time, change_time) values (?,?,?,?,?,?,?,?,sysdate)');

	$self->{getQA} = $db->prepare('SELECT vraag, antwoord FROM adb132@lnkdea.kub.nl WHERE anr = ? ORDER BY seq');
	$self->{setQA} = $db->prepare('INSERT INTO adb132@lnkdea.kub.nl (anr, seq, vraag, antwoord) VALUES (?,?,?,?)');
	$self->{deleteQA} = $db->prepare('DELETE FROM adb132@lnkdea.kub.nl WHERE anr = ?');

	$self->{getMail} = $db->prepare('SELECT extmail, epoch_time FROM adb131@lnkdea.kub.nl WHERE anr = ?');
	$self->{setMail} = $db->prepare('INSERT INTO adb131@lnkdea.kub.nl (anr, extmail, epoch_time) VALUES (?,?,?)');
	$self->{deleteMail} = $db->prepare('DELETE FROM adb131@lnkdea.kub.nl WHERE anr = ?');

	$self->{setQAMTime} = $db->prepare('INSERT INTO adb131@lnkdea.kub.nl (anr, epochtime) VALUES (?,?)');

	$self->db($db);
	return $self;
}

sub commit {
	$self->db->commit;
}

sub rollback {
	$self->db->rollback;
}

sub query {
        my $name = shift;
        my $q = $self->{$name};
		# pas op, soms is @_ leeg, daarom niet in de warn opnemen
		warn "running query: $name";
        $q->execute(@_);
        return $q;
}

sub query_fetchall {
	my $q = $self->query(@_);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res;
}

sub query_do {
	my $q = $self->query(@_);
	$q->finish;
}


sub getQA {
	my $anr = shift;
	my $res = $self->query_fetchall('getQA', $anr);
	my $n = @$res;
	die "Invalid number of questions ($n)"
		unless $n == 0 || $n == 2;
	return $res;
}

sub getQAStatus {
	my $anr = shift;
	my $res = $self->getQA($anr);
 	my $n = @$res;
	return $n?1:0;
}

sub setQA {
	my ($anr, $q1, $a1, $q2, $a2) = @_;
	$self->query_do('deleteQA', $anr);
	$self->query_do('setQA', $anr, 1, $q1, $a1) if ($q1 && $a1);
	$self->query_do('setQA', $anr, 2, $q2, $a2) if ($q2 && $a2);
}

sub getMail {
	my $anr = shift;
	my $res = $self->query_fetchall('getMail', $anr);
	my $n = @$res;
	die "Invalid number of mail addresses ($n)"
		if $n > 1;
	my $mail = $res->[0]->[0];
	return $mail || 0;
}

sub getQAMModified {
	my $anr = shift;
	my $res = $self->query_fetchall('getMail', $anr);
	my $list = @$res[0];
	my $time = 0;
	if ($list) {
		$time = $list->[1] if $list->[1];
	}
	return $time;
}


sub setMail {
	my ($anr, $mail) = @_;
	$self->query_do('deleteMail', $anr);
	$self->query_do('setMail', $anr, $mail, time);
}

sub setPwd {
	$self->query_do('setPwd', @_);
}

sub previousSHAPasswords {
	my $anr = shift;
	my $res = $self->query_fetchall('previousSHAPasswords', $anr);
	return [map { my $r = $_->[0]; $r } @$res];
}

sub getCurrentSHAPassword {
	my $anr = shift;
	my $a = $self->previousSHAPasswords($anr);
	return $a->[-1];
}

sub getDirtyRecords {
	my $res = $self->query_fetchall('getDirtyRecords');
	return @$res;
}

sub cleanRecord {
	my ($pw_rcrypt_before, $epochtime, $anr) = @_;
	$self->query_do('cleanRecord', $pw_rcrypt_before, $anr, $epochtime );
}


sub previousPasswords {
	my $anr = shift;
	my $res = $self->query_fetchall('previousPasswords', $anr);
	return [map { my $r = $_->[0]; $r =~ s/^\{rcrypt\}//; $r } @$res];
}

sub getInitialPassword {
	my $anr = shift;
	my $res = $self->query_fetchall('initialPassword', $anr);
	my $n = @$res;
	return $res->[0][0];
}


sub getCurrentRcryptPassword {
	my $anr = shift;
	my $a = $self->previousPasswords($anr);
	return $a->[-1];
}

sub getUsername {
	my $anr = shift;
	my $res = $self->query_fetchall('getUsername', $anr);
	my $n = @$res;

	if ($n == 1){
		return $res->[0][0];
	} else {
		warn "userError: No unique username for anr '$anr' found (count: $n)",Dumper($res);
		return undef;
	}
}

sub getAnr {
	my $uid = shift;
	my $res = $self->query_fetchall('getAnr', $uid);
	my $n = @$res;

	if ($n == 1){
		return $res->[0][0];
	} else {
		warn "userError: No unique anr for uid '$uid' found (count: $n)",Dumper($res);
		return undef;
	}

}
