# $Id: Replacer.pm 32698 2010-10-08 11:28:16Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/pwdmodifier/pwdmodifier/lib/UvT/PwdModifier/Replacer.pm $

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::Replacable;

use Spiffy -base;

sub new {
	my ($class, $string) = @_;
	my $self = "$string";
	return bless \$self, $class;
}

sub toString {
	my $self = shift;
	return $$self;
}

use overload
	'""' => \&toString,
	'fallback' => 1;

package UvT::PwdModifier::Replacer;

use Carp;

use Spiffy -Base;

field 'items' => {};
field '_loop' => {};

our %htmlentities = (
    '"' => '&quot;',
    "'" => '&apos;',
    '<' => '&lt;',
    '>' => '&gt;',
    '&' => '&amp;',
);

sub _htmlentities() {
    my $html = shift;

    $html =~ s/(["'<>&])/$htmlentities{$1}/ge;
    $html =~ s/([^ -~])/'&#'.ord($1).';'/ge;

    return $html;
}

sub _subst1 {
	my $key = shift;

	my $items = $self->items;
	die "unknown key '$key'\n"
		unless exists $items->{$key};

	my $val = $items->{$key};
	die "undefined key '$key'\n"
		unless defined $val;

	return $val;
}

sub _substT {
	my $key = shift;
	my $val = $self->_subst1($key);

	die "unescaped expansion of '$key'\n"
		unless UNIVERSAL::isa($val, 'UvT::PwdModifier::Replacable');

	return $val;
}

sub _subst {
	my $key = shift;
	my $val = $self->_substT($key);

	my $loop = $self->_loop;
	die "loop detected for key '$key'\n"
		if exists $loop->{$key};

	undef $loop->{$key};
	my $str = eval { $self->replace($val) };
	delete $loop->{$key};
	die "while replacing key '$key': $@" if $@;
	return $str;
}

sub replace {
	my $str = shift;

	confess "undefined parameter for Replacer::replace"
		unless defined $str;

	# $a    shorthand for ${a}
	# ${a}  replace recursively
	# $(a)  replace once
	# $<a>  replace once and escape entities

	$str =~ s/\$(?:\$|([a-z_]\w*)|\{([^}]*)\}|\(([^)]*)\)|\<([^>]*)\>)/
			my $rep = '$';
			if(defined $1) {
				$rep = $self->_subst($1)
			} elsif(defined $2) {
				$rep = $self->_subst($2)
			} elsif(defined $3) {
				$rep = $self->_substT($3)
			} elsif(defined $4) {
				$rep = _htmlentities($self->_subst1($4))
			}
			$rep
		/eig;

	return $str;
}
