# $Id: Gimme.pm 32959 2010-11-05 14:24:22Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/Gimme.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::Gimme;

use UvT::Loandesk::Handler -self;

field methods => [];

sub handle {
	foreach my $handler (@{$self->methods}) {
		my $res = $handler->handle(@_);
		return $res if defined $res;
	}
	return super;
}

package UvT::Loandesk::Order::Request;

use UvT::Loandesk::Request -self;

sub pica {
	return unless $self->submit;
	my $epn = $self->epn or return;
	my $volumeid = $self->volumeid or return;
	return unless $self->nonce;
	my $anr = $self->anr or return;

	return $self->mps->order($anr, $epn, $volumeid);
}

sub requesttype { 'order' }

package UvT::Loandesk::Order;

use UvT::Loandesk::Gimme -self;

sub handle {
	my $req = new UvT::Loandesk::Order::Request(cfg => $self, ctx => shift);
	return super($req);
}

package UvT::Loandesk::Reserve::Request;

use UvT::Loandesk::Request -self;

sub pica {
    return unless $self->submit;
    my $epn = $self->epn or return;
    my $volumeid = $self->volumeid or return;
    return unless $self->nonce;
    my $anr = $self->anr or return;

	return $self->mps->reserve($anr, $epn, $volumeid);
}

sub requesttype { 'reserve' }

package UvT::Loandesk::Reserve;

use UvT::Loandesk::Gimme -self;

sub handle {
	my $req = new UvT::Loandesk::Reserve::Request(cfg => $self, ctx => shift);
	return super($req);
}

package UvT::Loandesk::OrderFree::Request;

use UvT::Loandesk::Request -self;

param year => sub {
	my $self = shift;
	die $self->errorpage('Application error', 'year parameter missing')
		unless $_;
	die $self->errorpage('Application error', 'year parameter not valid')
		unless /^\d+$/;
};

param volume => sub {
	die shift->errorpage('Application error', 'volume parameter not valid')
		if defined && /[^\w-]/;
};

param issue => sub {
	die shift->errorpage('Application error', 'issue parameter not valid')
		if defined && /[^\w-]/;
};

sub pica {
    return unless $self->submit;
    my $epn = $self->epn or return;
    return unless $self->nonce;
    my $anr = $self->anr or return;

	return $self->mps->orderFree($anr, $epn, $self->year, $self->volume, $self->issue);
}

sub requesttype { 'order_free' }

package UvT::Loandesk::OrderFree;

use UvT::Loandesk::Gimme -self;

sub handle {
	my $req = new UvT::Loandesk::OrderFree::Request(cfg => $self, ctx => shift);
	return super($req);
}
