# $Id: AuthBroker.pm 33754 2011-02-03 14:05:41Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/AuthBroker.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::AuthBroker::Config;

use Xyzzy -self;

field authbroker_expiry => 43200;
field authbroker_host => sub { die "no AuthBrokerHost configured\n" };
field authbroker_port => 4033;
field authbroker_timeout => 10;

*set_authbrokerhost = *authbroker_host;
*set_authbrokerport = *authbroker_port;
sub set_authbrokerexpiry { $self->authbroker_expiry(parse_time(@_)) }
sub set_authbrokertimeout { $self->authbroker_timeout(parse_time(@_)) }

package UvT::Loandesk::AuthBroker;

use Clarity -self;
use UvT::Loandesk::LDAP -mixin;

use UvT::Loandesk::Crypto;

field cfg;
field authbroker_expiry => sub { shift->cfg->authbroker_expiry };
field authbroker_host => sub { shift->cfg->authbroker_host };
field authbroker_port => sub { shift->cfg->authbroker_port };
field authbroker_timeout => sub { shift->cfg->authbroker_timeout };

sub broke_auth {
	my $uid = shift or return;
	my $pwd = shift or return;

	my $sock = new IO::Socket::INET(
		PeerAddr => $self->authbroker_host,
		PeerPort => $self->authbroker_port,
		Timeout => $self->authbroker_timeout
	);

	die "can't connect to authbroker: $!\n"
		unless defined $sock;

	$sock->autoflush(0);
	binmode($sock)
		or die "can't set socket binmode: $!\n";

	my $login = new XML::LibXML::Document('1.0', 'UTF-8');
	my $xrep = $login->createElement('xrep');
	$login->setDocumentElement($xrep);
	my $logonRequest = $login->createElement('logonRequest');
	$xrep->appendChild($logonRequest);

	$logonRequest->appendTextChild('userID', $uid);
	$logonRequest->appendTextChild('password', $pwd);
	$logonRequest->appendTextChild('requestSource', 'user');

	$login->toFH($sock, 1);
	$sock->flush;
	$sock->shutdown(1);

	my $parser = new XML::LibXML;
	$parser->pedantic_parser(1);
	$parser->validation(0);
	$parser->load_ext_dtd(0);
	$parser->expand_entities(0);
	$parser->keep_blanks(0);
	$parser->line_numbers(1);
	$parser->no_network(1);

	my $doc = $parser->parse_fh($sock);
	$sock->shutdown(2);
	$sock->close;
	undef $sock;

	return $doc->find('/xrep/logonResponse/group="extusr"');
}
