# $Id: SendRequest.pm 33784 2011-02-07 08:06:16Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/SendRequest.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

use UvT::Loandesk::List;

package UvT::Loandesk::SendRequest::Document;

use UvT::Loandesk::Document -self;
use UvT::Loandesk::List::Document -mixin;

sub build {
	my $feedback = $self->getElementById('feedback')
		or return;

	my $req = $self->req;

	$self->addTemplates('result', 'result/'.$req->requesttype);

	if(my $ophaaltype = $req->ophaaltype) {
		eval { $self->addTemplates("ophaaltype/$ophaaltype") };
		warn $@ if $@;
	}

	if(my $returndate = $req->returndate) {
		my ($frag, $ids) = $self->getFragment(returndate => 'havedate');
		$ids->{returndate}->appendText($returndate);
		my $el = $self->getElementById('returndate');
		$el->replaceNode($frag);
	} else {
		my ($frag) = $self->getFragment(returndate => 'nodate');
		my $el = $self->getElementById('returndate');
		$el->replaceNode($frag);
	}

	my $message = $req->message;
	my $mnemonic = $req->mnemonic;
	eval {
		die "No mnemonic found in MPS response ($message)\n" unless $mnemonic;
		my ($frag) = $self->getFragment(mps => $req->mnemonic);
		$feedback->replaceNode($frag);
	};
	if(my $err = $@) {
		$err =~ s/\n.*//;
		warn "Unable to load text for mnemonic: $err\n";
		$feedback->appendText($message);
	}
}

package UvT::Loandesk::SendRequest::Request;

use UvT::Loandesk::Request -self;
use UvT::Loandesk::List::Request -mixin;

field result;
field status;
field message => '';
field mnemonic => '';

sub send {
	my ($result, $status, $message, $mnemonic) = $self->pica
		or return;

	$self->result($result);
	$self->status($status);
	$self->message($message);
	$self->mnemonic($mnemonic);

	return 1;
}

package UvT::Loandesk::SendRequest;

use UvT::Loandesk::Handler -self;

sub handle {
	my $req = new UvT::Loandesk::SendRequest::Request(ctx => shift, cfg => $self);
	return unless $req->send;
	my $doc = new UvT::Loandesk::SendRequest::Document(req => $req);
	return $doc->response;
}
