# $Id: MPS.pm 33254 2010-12-06 16:42:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/MPS.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::MPS::Config;

use Xyzzy -self;

field mps => sub { die "no LoandeskMPS configured\n" };
*set_loandeskmps = *mps;

package UvT::Loandesk::MPS;

use Clarity -self;

use Time::HiRes qw(time);
use URI::Escape;

field cfg;
field mps => sub { shift->cfg->mps };

sub geturl {
	my $url = $self->mps;

	if(@_) {
		my %parms = @_;
		my $sep = index($url, '?') == -1 ? '?' : '&';
		while(@_) {
			my $key = shift;
			my $val = shift;
			next unless defined $val;
			$url .= $sep . uri_escape($key) . '=' . uri_escape($val);
			$sep = '&';
		}
	}

	return $url;
}

sub getxml {
	my $url = shift;

	our $parser;
	unless($parser) {
		$parser = new XML::LibXML;
		$parser->validation(0);
		$parser->load_ext_dtd(0);
		$parser->expand_entities(0);
		$parser->pedantic_parser(1);
#		$parser->no_network(1);
	}

	return $parser->parse_file($url);

	my $start = time;
	my $xml = $parser->parse_file($url);
	warn sprintf("\%s (\%.2fs)\n", $url, time - $start);
	return $xml;
}

sub gettitle {
	my $epn = shift;
	my $url = $self->geturl(action => 'titleInfo', epn => $epn, format => 'd');
	my $xml = $self->getxml($url);
	my $title = $xml->findvalue('/xrep/pica3Response/item/kmc[@value="4000"]');
	$title =~ s/@//;
	return $title;
}

sub xml2hash() {
	my $xml = shift;
	my %res;
	foreach my $node ($xml->childNodes) {
		my $key = $node->nodeName || next;
		my $val = $node->textContent;
		$res{$key} = $val;
	}
	return \%res;
}

sub getvolumes {
	my $epn = shift;
	my $url = $self->geturl(action => 'listVolumes', epn => $epn);
	my $xml = $self->getxml($url);
	my @vols;
	my %vols;
	foreach my $vol ($xml->findnodes('/xrep/pica3Response/item')) {
		my $res = xml2hash($vol);
		push @vols, $res;
		$vols{$res->{volumeId}} = $res;
	}
	return wantarray ? @vols : \%vols;
}

sub request {
	my $url = $self->geturl(@_);
	my $xml = $self->getxml($url);
	my $status = $xml->findvalue('/xrep/pica3Response/diagnostic/diagnosticCode');
	die "$url: Can't find response code in reply to $url\n"
		unless $status;
	my $message = $xml->findvalue('/xrep/pica3Response/diagnostic/diagnosticString');
	my $mnemonic = $xml->findvalue('/xrep/pica3Response/diagnostic/diagnosticString/@mnemonic');
	if($status eq 'OK') {
		return 1, $status, $message, $mnemonic;
	} else {
		return undef, $status, $message, $mnemonic
			if $message;
		my $krak = $xml->findvalue('/xrep/pica3Response/diagnostic/diagnosticAddInfo');
		if($krak) {
			die "$url: $status ($krak)\n";
		} else {
			die "$url: $status\n";
		}
	}
}

sub order {
	my ($anr, $epn, $volumeid) = @_;
	return $self->request(action => 'requestBook', user => $anr, epn => $epn, volumeID => $volumeid);
}

sub orderFree {
	my ($anr, $epn, $year, $volume, $issue) = @_;
	return $self->request(action => 'requestFreeBook', user => $anr, epn => $epn,
		year => $year, volume => $volume, issue => $issue);
}

sub reserve {
	my ($anr, $epn, $volumeid) = @_;
	return $self->request(action => 'reserveBook', user => $anr, epn => $epn, volumeID => $volumeid);
}

sub loans {
	my $anr = shift;
	my $url = $self->geturl(action => 'listLoans', user => $anr);
	my $xml = $self->getxml($url);
	my @books = map { xml2hash($_) } $xml->findnodes('/xrep/pica3Response/item');
	return wantarray ? @books : \@books;
}

sub reservations {
	my $anr = shift;
	my $url = $self->geturl(action => 'listReservations', user => $anr);
	my $xml = $self->getxml($url);

	my @books = map { xml2hash($_) } $xml->findnodes('/xrep/pica3Response/item');
	return wantarray ? @books : \@books;
}
