# $Id: List.pm 33254 2010-12-06 16:42:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/List.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::List::Document;

use Unicode::Normalize;

use UvT::Loandesk::Document -self;

sub trim() {
	my $str = NFC(shift);
	$str =~ s/\s+/ /g;
	$str =~ s/^ | $//g;
	return $str;
}

sub trimmed() {
	my $title = shift;
	$title .= "…" if length($title) > 32;
	return trim($title);
}

sub build {
	$self->addTemplates('list');

	my $req = $self->req;

	my $loans = $req->loans;
	if(@$loans) {
		my $list = $self->getElementById('loans');
		foreach my $loan (@$loans) {
			$list->appendTextChild('li', trimmed($loan->{title}));
		}
	} else {
		my $list = $self->getElementById('listLoans');
		$list->parentNode->removeChild($list);
	}
	
	my $reservations = $req->reservations;
	if(@$reservations) {
		my $list = $self->getElementById('reservations');
		foreach my $res (@$reservations) {
			$list->appendTextChild('li', trimmed($res->{title}));
		}
	} else {
		my $list = $self->getElementById('listReservations');
		$list->parentNode->removeChild($list);
	}
}

package UvT::Loandesk::List::Request;

use UvT::Loandesk::Request -self;

const loans => sub {
	my $self = shift;
	my $loans = $self->mps->loans($self->anr)
		or die $self->errorpage('Error', 'No loans');
	return $loans;
};

const reservations => sub {
	my $self = shift;
	my $reservations = $self->mps->reservations($self->anr)
		or die $self->errorpage('Error', 'No reservations');
	return $reservations;
};

package UvT::Loandesk::List;

use UvT::Loandesk::Handler -self;

sub handle {
	my $req = new UvT::Loandesk::List::Request(ctx => shift, cfg => $self);
	my $doc = $req->anr
		? new UvT::Loandesk::List::Document(req => $req)
		: new UvT::Loandesk::Login::Document(req => $req);
	return $doc->response;
}
