# $Id: Form.pm 33754 2011-02-03 14:05:41Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/Form.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::Form::Document;

use UvT::Loandesk::Document -self;

sub build {
	my $cfg = $self->cfg;
	my $req = $self->req;

	my $epn = $req->epn;
	my $ophaaltype = $req->ophaaltype;
	my $title = $req->title;
#	my $vols = $req->volumes;
	my $back = $req->back;

	$self->addTemplates('request', 'request/'.$req->requesttype);

	my $content = $self->getElementById('pubtitle');
	$content->appendText($title);

	my $session = $req->session;
	my $nonce = $cfg->crypto->create_token('n'.$session, '');

	my $hidden = $self->getElementById('nonce');
	$hidden->setAttribute('value', $nonce);

#	if(@$vols > 1) {
#		my $volInfo = $self->getElementById('volInfo');
#		foreach my $vol (@$vols) {
#			my $key = $vol->{volumeID};
#			my $val = $vol->{volInfo};
#			my ($frag, $ids) = $self->getFragment('request', 'volume');
#			$ids->{input}->setAttribute('value', $key);
#			$ids->{input}->setAttribute('checked', 'checked')
#				if defined $volume && $key eq $volume;
#			$ids->{label}->appendText($val);
#			$volInfo->appendChild($frag);
#		}
#	} else {
#		my $vol = $vols->[0];
#		my $key = $vol->{volumeID};
#		$hidden = $self->createElement('input');
#		$hidden->setAttribute('type', 'hidden');
#		$hidden->setAttribute('name', 'volume');
#		$hidden->setAttribute('value', $key);
#		my $listVolumes = $self->getElementById('listVolumes');
#		$listVolumes->replaceNode($hidden);
#	}

	my $state = $self->getElementById('state');

	my %hide;
	@hide{qw(epn volumeid back ophaaltype year volume issue returndate)} = ();
	foreach my $param ($req->param) {
		next unless exists $hide{$param};
		my $value = $req->param($param);
		$hidden = $self->construct('input', {
			type => 'hidden',
			name => $param,
			value => $value,
		});
		$state->appendChild($hidden);
	}

	if(my $listVolumes = $self->getElementById('listVolumes')) {
		$listVolumes->parentNode->removeChild($listVolumes);
	}

	if($req->have_anr) {
		$self->addTemplates('loggedin');
	} else {
		my $organization = $req->organization;
		if($organization) {
			my $radio = $self->getElementById("organization_$organization");
			$radio->setAttribute('checked', 'checked')
				if defined $radio;

			my $login = $self->getElementById('login');
			$login->parentNode->removeChild($login)
				if $organization eq 'extusr' && $req->authbroker_login;
		}
	}
}

package UvT::Loandesk::Form::Request;

use UvT::Loandesk::Request -self;

const volumes => sub {
	my $self = shift;
	my @vols = $self->mps->getvolumes($self->epn)
		or die $self->errorpage('Error', 'No volumes available');
	return \@vols;
};

const title => sub {
	my $self = shift;
	my $title = $self->mps->gettitle($self->epn)
		or die $self->errorpage('Error', 'Unknown publication');
	return $title;
};

package UvT::Loandesk::Form;

use UvT::Loandesk::Handler -self;

sub handle {
	my $req = new UvT::Loandesk::Form::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Loandesk::Form::Document(req => $req);
	return $doc->response;
}
