# $Id: Aselect.pm 32459 2010-09-15 08:13:54Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/Aselect.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::Aselect::Config;

use Xyzzy -self;

field aselect_id => sub { die "no LoandeskAselectID configured\n" };
*set_loandeskaselectid = *aselect_id;

package UvT::Loandesk::Aselect;

use Clarity -self;

use Aselect::Client;

field cfg;
field aselect_id => sub { shift->cfg->aselect_id };

sub verify_ticket {
	return aselect_verify_ticket(@_);
}

sub verify_credentials {
	return aselect_verify_credentials(@_);
}

sub authenticate {
	return aselect_authenticate($self->aselect_id, @_);
}
