package Mailchallenge;
use strict;
use Baseobject;
use FileHandle;
use Carp;
use MIME::Base64;
use Digest::SHA1  qw(sha1_hex);

# $Id: Mailchallenge.pm 33209 2010-11-30 16:25:08Z anton $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/pwdmodifier/keymaster/lib/Mailchallenge.pm $


our @ISA=('Baseobject' );
our @EXPORT = qw (verbosity);

sub new
{
  my $pkg=shift;
  my $self= bless (new Baseobject(@_),$pkg);

  $self->{allowallfields}=1;

  $self->field('name','Mailchallenge');

  $self->needs(
	       [ qw ( anr ipaddress emailaddress cn sn language
		      mailprogram mailchallengesubject mailchallengetext
		      mailerrorsto mailfrom
		      url minimumlifespan contact
              token
		      )
		 ]
	       );


  $self->allows ( {  'tildeusername' => '' });

  #
  # allow this because of the parameter substitution method
  # which uses $self->{fields} as source ..
  #
  $self->allows ( [ qw (challenge mailto time mailalso2) ] );
  my $cf=shift;

  #note: merge parameters from configfile and commandline
  $self->fields(@_);
  $self->fields($self->getparms($cf));
  $self->checkneeds();

  return $self;
}


sub getparms
{
  my $self=shift;
  my $cf=shift;
#  warn $self->inspect($cf);
  my $h;

  # all variables read from cf MUST first be mentioned here
  foreach my $el (qw (mailprogram mailchallengesubject mailerrorsto
		      mailfrom url minimumlifespan contact mailalso2 ))
  {
    $h->{$el}= $cf->value($el);
  }

  warn $cf->error() if ($cf->error());
  $h->{mailchallengetext}=join ("\n", map {s/\\n//; $_;} $cf->value('mailchallengetext'));

  return $h;
}


sub mailuser
{
  my $self=shift;

  $self->field('time', scalar (localtime));

  $self->{fields}->{'tildeusernamepath'}=$self->{fields}->{tildeusername}?"~$self->{fields}->{tildeusername}/":"";
  $self->expandvars(\$self->{fields}->{url},$self->{fields});
  $self->expandvars(\$self->{fields}->{mailchallengetext},$self->{fields});

#  warn $self->inspect($self->{fields});

  my @mailto = ($self->{fields}->{emailaddress});
  @mailto = ("$self->{fields}->{tildeusername}\@uvt.nl") if $self->{fields}->{tildeusername};
  push @mailto, "$self->{fields}->{mailalso2}\@uvt.nl" if $self->{fields}->{mailalso2};

  my $mailto = join(', ', @mailto);

  die "bad e-mail address in $mailto"
    if grep { /^-/ } @mailto;

  my $mailhandle=new FileHandle();
  if (open ( $mailhandle , '|-', $self->{fields}->{mailprogram}, '-f', $self->{fields}->{mailerrorsto}, @mailto ))
  {
    my $mail = join ("\n",
		     (
		      "To: $mailto",
		      "X-mailer: perl $]",
		      "Subject: $self->{fields}->{mailchallengesubject}",
		      "Precedence: bulk",
		      "From: $self->{fields}->{mailfrom}",
		      "Errors-to: $self->{fields}->{mailerrorsto}",
		      "Mime-Version: 1.0",
		      "Content-Type: text/plain; charset=utf-8",
		      "Content-Disposition: inline",
		      "Content-Transfer-Encoding: 8bit",
		      "",
		      "$self->{fields}->{mailchallengetext}",
		      ));
    print $mailhandle $mail or die $!;
    close $mailhandle or die $!;
    warn "mail sent to $mailto anr:$self->{fields}->{anr}";
    $self->debug( "mail: $mail");

  }
  else
  {
    $self->error("keymaster status: Failure: Could not mail: $!");
  }
}
