/******************************************************************************

	worker.h -- bookkeeping for known transponder nodes
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: worker.h 7684 2005-05-24 09:11:10Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/worker.h $

******************************************************************************/

#ifndef WORKER_H
#define WORKER_H

#include <sys/types.h>
#include <sys/socket.h>

#include <avl.h>

#include "address.h"

typedef struct worker {
	/* for adding it to workers_name */
	avl_node_t node;
	/* for adding it to workers_best */
	avl_node_t best;
	/* contains address_t * nodes, sorted by name */
	avl_tree_t addr;
	/* contains address_t * nodes, sorted by priority */
	avl_tree_t prio;
	int hysteresis;
	int capacity;
	u16 nconn;
	char name[1];
} worker_t;

extern worker_t *worker_new(const char *);
extern worker_t *worker_byname(const char *);
extern void worker_update(worker_t *, int, const struct sockaddr *, socklen_t);
extern struct address *worker_bestaddress(void);
extern unsigned int worker_count(void);

#endif
