/******************************************************************************

	fair.h -- common header file for the "fair" project
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: fair.h 7065 2005-03-10 17:48:16Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/fair.h $

******************************************************************************/

#ifndef FAIR_H
#define FAIR_H

#include <stdint.h>
#include <stdbool.h>

#include "error.h"
#include "config.h"

#ifdef TRUE
#undef TRUE
#endif

#ifdef FALSE
#undef FALSE
#endif

#define TRUE true
#define FALSE false

#ifndef SOCK_UNSPEC
#define SOCK_UNSPEC 0
#endif
#ifndef PROTO_UNSPEC
#define PROTO_UNSPEC 0
#endif

typedef long double real;
typedef unsigned char byte;

typedef int_least8_t s8;
typedef uint_least8_t u8;
typedef int_least16_t s16;
typedef uint_least16_t u16;
typedef int_least32_t s32;
typedef uint_least32_t u32;
typedef int_least64_t s64;
typedef uint_least64_t u64;

typedef s32 unichar_t;

#undef assert
#ifdef DEBUG
#define assert(x) do { if(!(x)) syslog_exit(LOG_ERR, "Internal error: assert(%s) failed at %s:%d; program exit", #x, __FILE__, __LINE__); } while(FALSE)
#define unless(x) if(!(x) && (syslog_exit(LOG_ERR, "Internal error: assert(%s) failed at %s:%d; program exit", #x, __FILE__, __LINE__), TRUE))
#else
#define assert(x)
#define unless(x) if(!(x))
#endif

#endif
