/******************************************************************************

	error.h -- error handling/printing
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: error.h 6337 2004-11-26 14:48:00Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/error.h $

******************************************************************************/
#ifndef ERROR_H
#define ERROR_H

#include <stdlib.h>
#include <errno.h>
#include <syslog.h>

#define syslog_exit(...) exit((syslog(__VA_ARGS__), 1))

extern int eprintf(const char *, ...) __attribute__((format(printf, 1, 2)));
extern int eputs(const char *);
extern void perror_exit(const char *) __attribute__((noreturn));
extern void error_exit(const char *, ...) __attribute__((noreturn, format(printf, 1, 2)));
extern void *xalloc(size_t) __attribute__((malloc));
extern void *xrealloc(void *, size_t);
extern char *xstrdup(const char *) __attribute__((malloc));

#endif
