/******************************************************************************

	fd.h -- UNIX file descriptor bookkeeping and handling
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: fd.h 6337 2004-11-26 14:48:00Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/fd.h $

******************************************************************************/

#ifndef FD_H
#define FD_H

#include <avl.h>
#include <sys/select.h>

#include "fair.h"
#include "chrono.h"

typedef enum {
	FD_EVENT_READ,
	FD_EVENT_WRITE,
	FD_EVENT_OOB
} fd_event_t;

struct fd;

typedef void (*fd_hook_t)(struct fd *, fd_event_t);

typedef struct fd {
	avl_node_t node;
	int fd;
	fd_hook_t rfunc;
	fd_hook_t wfunc;
	fd_hook_t ofunc;
	void *rdata;
	void *wdata;
	void *odata;
} fd_t;

extern unsigned int fd_count(void);
extern fd_t *fd_new(int);
extern void fd_delete(fd_t *);
extern void fd_close(fd_t *);
extern fd_t *fd_byfd(int);
extern void fd_read(fd_t *, fd_hook_t, void *);
extern void fd_write(fd_t *, fd_hook_t, void *);
extern void fd_oob(fd_t *, fd_hook_t, void *);
extern int fd_select(stamp_t);

#endif
