/******************************************************************************

	chrono.h -- timer and timestamp functionality
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: chrono.h 6337 2004-11-26 14:48:00Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/chrono.h $

******************************************************************************/
#ifndef CHRONO_H
#define CHRONO_H

#include <sys/select.h>
#include <avl.h>

#include "fair.h"

#define STAMP_TICKS 1000000LL

typedef s64 stamp_t;
extern stamp_t now;

struct chrono;

typedef void (*chrono_hook_t)(struct chrono *);

typedef struct chrono {
	avl_node_t node;
	avl_tree_t *tree;
	stamp_t expiry;
	chrono_hook_t func;
	void *data;
} chrono_t;

extern unsigned int chrono_count(void);
extern chrono_t *chrono_new(chrono_hook_t, void *);
extern void chrono_at(chrono_t *, stamp_t);
extern void chrono_after(chrono_t *, stamp_t);
extern void chrono_disable(chrono_t *);
extern void chrono_delete(chrono_t *);
extern stamp_t chrono_events(void);

extern stamp_t stamp_get(const struct timeval *);
extern void stamp_sync(void);
extern void stamp_tv(struct timeval *, stamp_t);
extern void stamp_now(struct timeval *);

#endif
