/******************************************************************************

	options.h -- the configuration options that "fair" accepts
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: options.h 7576 2005-05-17 07:44:24Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/options.h $

******************************************************************************/

#ifndef _ConfigVal
#define _ConfigVal(k,d)
#endif
#ifndef _StringConfigVal
#define _StringConfigVal(s,d) _ConfigVal(s,d)
#endif
#ifndef _BoolConfigVal
#define _BoolConfigVal(b,d) _ConfigVal(b,d)
#endif
#ifndef _StampConfigVal
#define _StampConfigVal(t,d) _ConfigVal(t,d)
#endif
#ifndef _SizeConfigVal
#define _SizeConfigVal(s,d) _ConfigVal(s,d)
#endif
#ifndef _RegexConfigVal
#define _RegexConfigVal(r,d) _ConfigVal(r,d)
#endif

_BoolConfigVal(Debug, "no")
_BoolConfigVal(DropPrivs, "yes")

_StringConfigVal(PidFile, "/var/run/fair.pid")

_StringConfigVal(UserID, "nobody")
_StringConfigVal(GroupID, "nogroup")

_StringConfigVal(WorkerService, "smtp")
_StringConfigVal(TransponderService, "rlp")
_StringConfigVal(BalancerService, conf_WorkerService)

_SizeConfigVal(ConnectAttempts, "3")
_StampConfigVal(ConnectTimeout, "1")
_StampConfigVal(IdleTimeout, "300")
_StampConfigVal(PingTimeout, "0.5")
_StampConfigVal(PingInterval, "0.1")
_StampConfigVal(BenchPeriod, "5")

_SizeConfigVal(MaxCapacity, "100");

_SizeConfigVal(MinBurst, "1450");
_SizeConfigVal(MaxBurst, "65536");

_RegexConfigVal(AllowUDP, ".");

#undef _ConfigVal
#undef _StringConfigVal
#undef _BoolConfigVal
#undef _StampConfigVal
#undef _SizeConfigVal
#undef _RegexConfigVal
