package ToggleRadius;
use strict;
use warnings  FATAL=> 'all';

our @ISA=('Baseobject' );
use FileHandle;
use Baseobject;
use Exporter;
use Net::LDAPS;
use Net::LDAP;
use Encode;

use Ldapsearch;

my $singleorder= [qw ()];

sub new {
	my $pkg = shift;
	my $self= bless (new Baseobject(@_),$pkg);

	$self->needs([qw(uid cfhash secrethash radiusAdminAccount errorLog)]);

	$self->fields(@_);
	$self->checkneeds();
	$self->connect2ldap();
	$self->toggleRadius();
	return $self;
}

sub connect2ldap {
	my $self = shift;

	my $connectHash;
	$connectHash->{cfhash} = $self->{fields}->{cfhash};
	$connectHash->{serverinfo} = $self->{fields}->{cfhash}->{radiusServerInfo};
	$connectHash->{binddn} = $self->{fields}->{secrethash}->{uvtauthdn};
	$connectHash->{bindpwd} = $self->{fields}->{secrethash}->{uvtauthpwd};
	
	my $ldapConnection = new BaseLdapsearch($connectHash);
	if ($ldapConnection->error()) {
		my $error = $ldapConnection->error();
		chomp $error;
		die ("Ldap error: ",$error);
	}
	$self->{ldapConnection} = $ldapConnection;
}

sub toggleRadius {
	my $self = shift;
	my $filter = "uid=$self->{fields}->{uid}";
	my $msg = $self->{ldapConnection}->ldapsearch($filter);
	my @entries = $msg->entries;

	die "no match found for filter: '$filter'"
		unless @entries;

	die "multiple entries found for filter: '$filter'"
		if @entries > 1;

	my $entry = $entries[0];
	my @uvtAuthValues = $entry->get_value('uvt-auth');

	my $blockedString = $self->{fields}->{cfhash}->{radiusBlockedUvTAuthString};
	my $defaultString = $self->{fields}->{cfhash}->{radiusDefaultUvTAuthString};
	my $normal = grep(/^$defaultString$/, @uvtAuthValues);
	my @newAuthValues;
	my $subsinfo;

	if ($normal)  {
		warn "Blocking: $self->{fields}->{uid}";
		@newAuthValues =  grep(!/^$defaultString/, @uvtAuthValues);
		my ($d,$m,$y) = (localtime)[3,4,5];
		my $date = sprintf '%04d-%02d-%02d', $y + 1900, $m +1, $d;
		push(@newAuthValues, "$blockedString at $date");
		$subsinfo->{blocked} = 'blocked';
		
	} else {
		@newAuthValues = grep(!/^$blockedString/, @uvtAuthValues);
		warn "Unblocking: $self->{fields}->{uid}";
		$subsinfo->{blocked} = 'unblocked';
		push(@newAuthValues, $defaultString);
	}

	$entry->replace('uvt-auth' => [@newAuthValues]);
	$msg = $entry->update($self->{ldapConnection}->{ldap});
	die "Could not ldap->replace: ". $msg->error if $msg->code;

	$subsinfo->{uid} = $self->{fields}->{uid};
	$subsinfo->{anr} = $entry->get_value('employeenumber'); 
	$subsinfo->{surname} = $entry->get_value('sn'); 
	$subsinfo->{givenname} = $entry->get_value('givenname'); 
	$subsinfo->{mail} = $entry->get_value('mail'); 
	
	$self->radiusMail($subsinfo);
}

sub mime_encode {
	my $raw = $_[0];
	return encode('MIME-Header', $raw, 1);
}


sub radiusMail {
	my ($self, $subsinfo) = @_;
	my $cfhash = $self->{fields}->{cfhash};
	# add cfhash to subsinfo:
	map {$subsinfo->{$_} = $cfhash->{$_}} (keys(%$cfhash));

	$subsinfo->{radiusAdminAccount} = $self->{fields}->{radiusAdminAccount};
	my $mailText = $self->{fields}->{cfhash}->{radiusMailText};

	$self->expandvars(\$mailText, $subsinfo);

	my $mailsubject = $subsinfo->{radiusMailSubject}; 
	$self->expandvars(\$mailsubject, $subsinfo);
	my $log = $self->{fields}->{errorLog};

	my $cfh;
	$cfh -> {"mailfrom"} = $subsinfo->{radiusMailFrom}; 
	$cfh -> {"reply-to"} = 'noreply@uvt.nl';
	$cfh -> {"mailprogram"} = $log->{fields}->{mailprogram};
	$cfh -> {"mailerrorsto"} = $log->{fields}->{mailerrorsto};
	$cfh -> {"subject"} = mime_encode ($mailsubject);

	foreach my $mailTarget (split (/\s*,\s*/, $subsinfo->{radiusMailTarget})) {
		my $mailhandle = new FileHandle();
		if (open($mailhandle, '|-:utf8', $cfh->{mailprogram}, '-oi', '-f <>', '-t')) {
			my $mail = join("\n",
							(
							 "To: <$mailTarget>",
							 "X-mailer: perl $]",
							 "Subject: $cfh->{subject}",
							 "Precedence: bulk",
							 "From: $cfh->{mailfrom}",
							 "Reply-To: $cfh->{'reply-to'}",
							 "Mime-Version: 1.0",
							 "Content-Type: text/plain; charset=utf-8",
							 "Content-Disposition: inline",
							 "Content-Transfer-Encoding: 8bit",
							 "",
							 $mailText,
							));

			print $mailhandle $mail;
			close $mailhandle;
			warn "mail sent to: $mailTarget";
		}  	else {
			die "Could not mail to $mailTarget: $!";
		}
	}
}
