<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match='/top'>
  <!-- jacket.xml is inserted here -->

  </xsl:template>

  <!-- ####################################################################################### -->
  <xsl:template match="apptop">

    <xsl:if test="searchbox">
      <span id="insert_dynamic_xml"/>
    </xsl:if>

    <div id="ldapbrowserstyle">

      <xsl:if test="hierarchy">
        <div id="hierarchy">
          <xsl:for-each select="hierarchy">
            <table border="0" cellspacing="0" cellpadding="0"  >
              <tr>
                <xsl:apply-templates select="."/>
              </tr>
            </table>
          </xsl:for-each>
        </div>
      </xsl:if>

      <xsl:if test="userfeedback">
        <table border="1" cellpadding="0" cellspacing="0" class="userfeedback" id="feedback" >
          <tr><td><xsl:value-of select='userfeedback/@display'/></td></tr>
          <xsl:if test="userfeedback/line">
            <tr><td>
              <table border="0" cellpadding="0" cellspacing="0" class="userfeedbacklines">
                <xsl:apply-templates select="userfeedback/line"/>
              </table>
            </td></tr>
          </xsl:if>
        </table>
      </xsl:if>

      <xsl:if test="numberofhits">
        <table border="0" cellpadding="0" cellspacing="0"  class="numberofhits" >
          <tr>
            <th><xsl:apply-templates select="numberofhits/@title"/><xsl:text>:</xsl:text></th>
            <xsl:apply-templates select="numberofhits/value"/>
          </tr>
        </table>
      </xsl:if>

      <div class="results" >

        <div class="organisation">
          <xsl:if test="entry/toporganisation">
            <xsl:call-template name="presentOrganisations">
              <xsl:with-param name="orgType">toporganisation</xsl:with-param>
            </xsl:call-template>
          </xsl:if>

          <xsl:if test="entry/suborganisation">
            <xsl:call-template name="presentOrganisations">
              <xsl:with-param name="orgType">suborganisation</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
       </div>

        <!-- alle humans in één tabel en wel in deze volgorde -->
        <table cellspacing="0" cellpadding="0" class="humans">
          <xsl:if test="entry/*[starts-with(name(),'staff')]">
            <xsl:call-template name="presentHumans" >
              <xsl:with-param name="humanType">staff</xsl:with-param>
            </xsl:call-template>
          </xsl:if>

          <xsl:if test="entry/pnil">
            <tr><td class="whiteline"></td></tr>
            <xsl:call-template name="presentHumans" >
              <xsl:with-param name="humanType">pnil</xsl:with-param>
            </xsl:call-template>
          </xsl:if>

          <xsl:if test="entry/student">
            <tr><td class="whiteline"></td></tr>
            <xsl:call-template name="presentHumans" >
              <xsl:with-param name="humanType">student</xsl:with-param>
            </xsl:call-template>
          </xsl:if>

          <xsl:if test="entry/guest">
            <tr><td class="whiteline"></td></tr>
   	        <xsl:call-template name="presentHumans" >
              <xsl:with-param name="humanType">guest</xsl:with-param>
            </xsl:call-template>
          </xsl:if>

          <xsl:if test="entry/etranger">
            <tr><td class="whiteline"></td></tr>
            <xsl:call-template name="presentHumans" >
              <xsl:with-param name="humanType">etranger</xsl:with-param>
            </xsl:call-template>
          </xsl:if>

        </table>

        <xsl:if test="entry/mailalias">
          <table cellspacing="0" border="0" cellpadding="0" id="mailalias" >
            <tr><th class="mailalias"><xsl:value-of select="entry/mailalias/@title"/></th></tr>
            <xsl:apply-templates select="entry/mailalias" />
          </table>
        </xsl:if>
      </div>
    </div>
  </xsl:template>


  <xsl:template name="presentOrganisations">
    <xsl:param name="orgType"/>
          <table border="0" cellspacing="0" cellpadding="0" >
            <xsl:attribute name="class">
              <xsl:value-of select="$orgType"/>
            </xsl:attribute>
            <tr><xsl:call-template name="legenda"/></tr>
            <tr>
              <xsl:choose>
                <xsl:when test="entry/*[local-name()=$orgType]/type='single'">
                  <th><xsl:text></xsl:text></th>
                </xsl:when>
                <xsl:otherwise>
                  <th ><xsl:value-of select="entry/*[local-name()=$orgType]/@title"/></th>
                </xsl:otherwise>
              </xsl:choose>
              <th class="lookfor"><xsl:apply-templates select="/top/lookfor"/></th>
            </tr>

            <xsl:for-each select="entry/*[local-name()=$orgType]">
              <tr>
                <xsl:apply-templates select=".//attr"/>
              </tr>
            </xsl:for-each>
          </table>
  </xsl:template>

  <xsl:template name="presentHumans">
    <xsl:param name="humanType"/>

    <tbody >
      <xsl:attribute name="class">
        <xsl:value-of select="$humanType"/>
      </xsl:attribute>

      <tr>
        <xsl:choose>
          <xsl:when test="entry/*[local-name()=$humanType]/type='single'">
            <tr><xsl:call-template name="legenda"/></tr>
            <th>
              <xsl:attribute name="class">noprint</xsl:attribute>
              <xsl:value-of select="entry/*[local-name()=$humanType]/@title"/>
            </th>
            <td></td><th class="lookfor"><xsl:apply-templates select="/top/lookfor"/></th>
          </xsl:when>
          <xsl:otherwise>
            <th colspan="3">
              <xsl:value-of select="entry/*[local-name()=$humanType]/@title"/>
            </th>
            <xsl:call-template name="legenda"/>
          </xsl:otherwise>
        </xsl:choose>
      </tr>

      <xsl:if test="entry/*[local-name()=$humanType]/type='multiple'">
        <tr><xsl:apply-templates select="multableheaders/*[local-name()=$humanType]"/></tr>
      </xsl:if>
      <xsl:apply-templates select="entry/*[local-name()=$humanType]"/>
    </tbody>

  </xsl:template>

  <xsl:template name="legenda">
      <td class="legenda" colspan="10">
          <xsl:for-each select="/top/legenda">
            <span class="legabbr"><xsl:value-of select="./@abbrev"/></span>
            <span class="legtext"><xsl:value-of select="./@value"/></span>
          </xsl:for-each>
      </td>
  </xsl:template>

  <!--  ten behoeve van userfeedback -->
  <xsl:template match="line">
    <tr><td>
    <xsl:value-of select='.'/>
    <xsl:if test="@title">
      <xsl:value-of select="@title"/>
    </xsl:if>
    </td></tr>
  </xsl:template>


  <xsl:template match="multableheaders/student|multableheaders/staff|multableheaders/pnil|multableheaders/etranger|multableheaders/guest">
    <xsl:for-each select="multvalue">
      <th>
        <xsl:attribute name="class">
          <xsl:value-of  select="@class"/>
        </xsl:attribute>
        <xsl:value-of  select="."/>
      </th>
    </xsl:for-each>
  </xsl:template>


  <xsl:template match="*[starts-with(name(),'staff')]|pnil|student|mailalias|guest|etranger">
    <xsl:choose>
      <xsl:when test="../type='single'">
        <xsl:apply-templates select=".//attr"/>
      </xsl:when>
      <xsl:otherwise>
        <tr>
          <xsl:apply-templates select=".//attr"/>
        </tr>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="suborganisation">
    <tr class="imgvalue">
        <xsl:apply-templates select=".//attr"/>
    </tr>
  </xsl:template>

    <xsl:template match="toporganisation">
      <tr>
        <xsl:apply-templates select=".//attr"/>
      </tr>
    </xsl:template>

  <xsl:template match="attr[../type='single']">
    <tr>
      <xsl:if test="@class">
        <xsl:attribute name="class">
          <xsl:value-of  select="@class"/>
        </xsl:attribute>
      </xsl:if>
      <th>
        <xsl:apply-templates select="name"/>
      </th>
      <td>
        <xsl:call-template name="printvalues"/>
      </td>

      <td  >
        <table cellpadding="0" cellspacing="0" >
          <xsl:for-each select="value">
            <tr>
              <td class="imgmenu">
                <xsl:apply-templates select="./submenu"/>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="attr[../type='multiple' and substring(name/@class,4)='organisation']">
        <xsl:apply-templates select="value"/>
  </xsl:template>


  <xsl:template match="attr[../type='multiple' and not (substring(name/@class,4)='organisation')]">
    <xsl:variable name = "multivalued" >
          <xsl:value-of select="count(value)" />
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="$multivalued&gt;1">
        <td>
<!--        NAME: <xsl:value-of select="./name"/> BEGIN <xsl:value-of select="//@deeper"/> ++ -->

          <table cellpadding="0" cellspacing="0" class="multivalue" >
            <xsl:for-each select="value">
              <tr>
                <xsl:apply-templates select="."/>
              </tr>
            </xsl:for-each>
          </table>
        </td>

<!--        Organisation(s) and Organisatie(s), lelijk, zou op een ander element moeten, dit is vertaald...
-->
        <xsl:if test="substring(name,1,10)='Organisati'"> 

          <td>
<!--  	      <xsl:value-of select="value"/>
-->
            <table cellpadding="0" cellspacing="0" >
              <xsl:for-each select="value">
                <tr>
                  <td class="imgmenu">
                    <xsl:apply-templates select="./submenu"/>
                  </td>
                </tr>
              </xsl:for-each>
            </table>
          </td>
	   </xsl:if>

      </xsl:when>
      <xsl:otherwise>
        <!-- single value -->
        <xsl:apply-templates select="value"/>
        <xsl:if test="value/submenu">
          <td class="imgmenu">
            <xsl:apply-templates select="value/submenu"/>
          </td>
        </xsl:if>

      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="printvalues">
      <table cellpadding="0" cellspacing="0" class="multivalue" >
        <xsl:for-each select="value">
          <tr>
            <xsl:apply-templates select="."/>
          </tr>
        </xsl:for-each>
      </table>
  </xsl:template>

  <!--   ou menuutjes -->
  <xsl:template match="value[@deeper and @href]">
    <td nowrap="nowrap" >
      <xsl:attribute name="class">
        <xsl:value-of select="@class"/>
      </xsl:attribute>

      <a>
        <xsl:attribute name="href">
          <xsl:value-of select='@href'/>&amp;lan=<xsl:value-of select='/top/lan'/>
        </xsl:attribute>
        <xsl:value-of select="@deeper"/>
      </a>
    </td>
  </xsl:template>


  <xsl:template match="value[@deeper and not (@href)]">
    <td nowrap="nowrap"  >
      <xsl:attribute name="class">
        <xsl:value-of select="@class"/>
      </xsl:attribute>

        <xsl:value-of select="@deeper"/>
    </td>
  </xsl:template>


  <xsl:template match="value[@hierarchy]">
    <th nowrap="1" >
      <xsl:choose>
        <xsl:when test="@href">
          <a>
            <xsl:attribute name="href">
              <xsl:value-of select='@href' />&amp;lan=<xsl:value-of select='/top/lan'/>
              </xsl:attribute><xsl:attribute name="title"><xsl:value-of select="@title"/>
            </xsl:attribute>
            <xsl:value-of select="."/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>

    </th>
  </xsl:template>


  <xsl:template match="submenu">
    <xsl:choose>
      <xsl:when test="@href">
          <a class="findpeople">
            <xsl:attribute name="href">
              <xsl:value-of select='@href'/>&amp;lan=<xsl:value-of select='/top/lan'/>
            </xsl:attribute>
            <xsl:attribute name="title">
              <xsl:value-of select='@title'/>
            </xsl:attribute>
            <xsl:value-of select="@abbrev"/>
          </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="."/>
      </xsl:otherwise>

    </xsl:choose>
  </xsl:template>

  <xsl:template match="value">
    <td  nowrap="nowrap" class="value" >
      <xsl:choose>
        <xsl:when test="@href">
          <a>
            <xsl:attribute name="href">
              <xsl:value-of select='@href'/>
              <xsl:if test="not(@mailto)">
                    <xsl:text>&amp;lan=</xsl:text><xsl:value-of select='/top/lan'/>
              </xsl:if>
            </xsl:attribute>
            <xsl:attribute name="onclick">
              <xsl:value-of select='@onclick'/>
            </xsl:attribute>
            <xsl:value-of select="."/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </xsl:template>

  <xsl:template match="babelpool">
    <xsl:text>fiets</xsl:text>
  </xsl:template>

</xsl:stylesheet>
