# $Id: SPNEGO.pm 39779 2013-07-11 14:42:24Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/SPNEGO.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::SPNEGO;

use Convert::ASN1 0.26;

use Aselect::UI::SPNEGO::Request;
use Aselect::UI::SPNEGO::Authenticate;

use Aselect::Handler -self;

field success;
field spnego_principal => sub { shift->cfg->spnego_principal };

sub handle {
	my $req = new Aselect::UI::SPNEGO::Request(cfg => $self, ctx => shift);
	return if $req->renew;
	return $self->success->handle($req) if defined $req->uid;
	return unless $req->feasible;
	my $doc = new Aselect::UI::SPNEGO::Authenticate(req => $req);
	return $doc->response;
}

const asn1 => sub {
	my $asn1 = new Convert::ASN1;
	$asn1->configure(encoding => 'DER');
	$asn1->prepare(<<'EOT') or die $asn1->error;
		SPNEGO ::= [APPLICATION 0] SEQUENCE {
			spnego       MechType,
			negToken     NegotiationToken
		}

		NegotiationToken ::= CHOICE {
			negTokenInit    [0] EXPLICIT NegTokenInit,
			negTokenResp    [1] EXPLICIT NegTokenResp
		}

		MechType ::= OBJECT IDENTIFIER

		MechTypeList ::= SEQUENCE OF MechType

		NegTokenResp ::= SEQUENCE {
			negState       [0] EXPLICIT ENUMERATED,
			supportedMech  [1] EXPLICIT MechType      OPTIONAL,
			responseToken  [2] EXPLICIT OCTET STRING  OPTIONAL,
			mechListMIC    [3] EXPLICIT OCTET STRING  OPTIONAL
		}

		ContextFlags ::= BIT_STRING

		NegTokenInit ::= SEQUENCE {
			mechTypes      [0] EXPLICIT MechTypeList  OPTIONAL,
			reqFlags       [1] EXPLICIT ContextFlags  OPTIONAL,
			mechToken      [2] EXPLICIT OCTET STRING  OPTIONAL,
			mechListMIC    [3] EXPLICIT OCTET STRING  OPTIONAL
		}
EOT

	return $asn1->find('SPNEGO');
};
