# $Id: Error.pm 42424 2014-10-22 12:12:06Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Error.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Error;

use Aselect::UI::Document -self;

use constant rootname => 'error';

field type;
field args;

sub build {
	my $root = $self->documentElement;
	$root->appendChild($self->construct(code => $self->type));
	my $args = $self->args;
	if(%$args) {
		my $arglist = $self->construct('args');
		while(my ($key, $val) = each(%$args)) {
			$arglist->appendChild($self->construct($key, "$val"));
		}
		$root->appendChild($arglist);
	}
}
