# $Id: Request.pm 39279 2013-04-22 14:14:52Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::Request;

use Xyzzy::Util qw(parse_bool);

use Xyzzy::Request -self;

our @EXPORT_BASE = qw(bool_string bool_param);

sub bool_string() {
	return eval { parse_bool(shift) ? 'true' : 'false' };
}

sub bool_param(*) {
	my $name = shift;
	if(ref $name) {
		my $self = $name;
		$name = shift;
		my ($val) = $self->param($name)
			or return undef;
		return eval { parse_bool($val) } // 1;
	}
	my $package = caller;
	Clarity::Internals::field($package, $name, sub {
		my ($val) = shift->param($name)
			or return undef;
		return eval { parse_bool($val) } // 1;
	});
}

field dir => sub { shift->cfg->dir };
field crypto => sub { shift->cfg->crypto };
field request_timeout => sub { shift->cfg->request_timeout };
field org => sub { shift->cfg->organization };
field https_everywhere => sub { shift->cfg->https_everywhere };

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

sub apply_https_everywhere {
	my $url = shift;
	if($self->https_everywhere) {
		$url =~ s{^http:}{https:}i
			unless $url =~ m{^http://(?:localhost|127\.0\.0\.1)(?:[:/?#]|$)}i;
	}
	return $url;
}

bool_param renew;
