use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Hook;

use Clarity -self;

sub hook_call {
	my $method = shift;

	no strict 'refs';
	local our @calls = map {
			\&{"${_}::$method"}
		} grep {
			defined &{"${_}::$method"}
		} Clarity::Internals::all_my_bases(ref $self || $self);

	local our $called;

	return $self->hook_next(@_);
}

sub hook_next {
	return wantarray ? @_ : shift
		unless our @calls;
	local @calls = @calls;

	my $call = pop @calls;

	our $called = 1;

	return $call->($self, @_)
		unless @calls;

	local $called;

	if(wantarray) {
		my @res = $call->($self, @_);
		return hook_next($self, @res)
			unless $called;
		return @res;
	} else {
		my $res = $call->($self, @_);
		return hook_next($self, $res)
			unless $called;
		return $res;
	}
}
