use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Document::XHTML;

use Xyzzy::Document -self;

sub serialize {
	my $res = new Xyzzy::Response;

	if($self->req->msie) {
		$res->mimetype('text/html', charset => 'UTF-8');
		$res->content($self->toStringHTML);
	} else {
		$res->mimetype('application/xhtml+xml');
		$res->content($self->toString);
	}

	return $res;
}

sub build {
	$self->hook_next;
	foreach($self->findnodes('/*|/*/*|/*/head//*')) {
		$_->removeAttribute('id')
			if $_->hasAttributes
	}
}
