use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Directory::Request;

use Xyzzy::Request -self;

field cwd => sub { eval { super } // [] };
field path_components => sub { eval { super } // [grep($_, split(qr{/}, shift->path_info))] };

package Xyzzy::Directory;

use Xyzzy::Handler -self;

use Xyzzy::Fail;

field subdirs => {};
field fallback => sub { new Xyzzy::Fail(cfg => shift, code => 404) };

sub handle {
	my $req = new Xyzzy::Directory::Request(cfg => $self, ctx => shift);

	my $path = $req->path_components;
	my $cwd = $req->cwd;

	return $self->handler->handle($req, @_)
		unless @$path;

	my $dir = $path->[0];

	my $handler = $self->subdirs->{$dir};
	return $self->fallback->handle($req, @_)
		unless $handler;

	shift @$path;
	push @$cwd, $dir;

	return $handler->handle($req, @_);
}
