use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Database::Config;

use Clarity -self;

field db_dsn => sub { die "No db_dsn configured\n" };
field db_user => undef;
field db_pass => undef;

*set_db_dsn = *db_dsn;
*set_db_user = *db_user;
*set_db_pass = *db_pass;

field db_options => {
	PrintError => 0,
	RaiseError => 1,
	AutoCommit => 0,
	ShowErrorStatement => 1,
	pg_enable_utf8 => 1
};

package Xyzzy::Database::Request;

use Xyzzy::Request -self;

field db => sub { shift->cfg->conn };

package Xyzzy::Database;

use Xyzzy::Handler -self;

use Xyzzy::Database::Config;

use DBI;

field db_dsn => sub { shift->cfg->db_dsn };
field db_user => sub { shift->cfg->db_user };
field db_pass => sub { shift->cfg->db_pass };
field db_options => sub { shift->cfg->db_options };

field conn => sub {
	my $self = shift;
	return DBI->connect($self->db_dsn, $self->db_user, $self->db_pass, $self->db_options);
};

sub handle {
	my $req = new Xyzzy::Database::Request(ctx => shift, cfg => $self);
	if(my $db = $self->{conn}) {
		delete $self->{conn} unless $db->ping;
	}
	my $res = eval { super($req) };
	my $db = $self->{conn};
	if(defined $res) {
		if($db && $db->{Executed}) {
			$db->commit;
		}
	} else {
		if($db && $db->{Executed}) {
			local $@;
			eval { $db->rollback };
			warn $@ if $@;
		}
		die $@ if $@;
	}
	return $res;
}
